USE [master]
GO
IF EXISTS ( SELECT [name] FROM sys.databases WHERE [name] = 'ProTouch' )
DROP DATABASE [ProTouch]
GO

USE [master]
GO
/****** Object:  Database [ProTouch]    Script Date: 2016-03-29 17:26:00 ******/
CREATE DATABASE [ProTouch]
GO

ALTER DATABASE [ProTouch] SET COMPATIBILITY_LEVEL = 110
GO
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [ProTouch].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO
ALTER DATABASE [ProTouch] SET ANSI_NULL_DEFAULT OFF 
GO
ALTER DATABASE [ProTouch] SET ANSI_NULLS OFF 
GO
ALTER DATABASE [ProTouch] SET ANSI_PADDING OFF 
GO
ALTER DATABASE [ProTouch] SET ANSI_WARNINGS OFF 
GO
ALTER DATABASE [ProTouch] SET ARITHABORT OFF 
GO
ALTER DATABASE [ProTouch] SET AUTO_CLOSE OFF 
GO
ALTER DATABASE [ProTouch] SET AUTO_SHRINK OFF 
GO
ALTER DATABASE [ProTouch] SET AUTO_UPDATE_STATISTICS ON 
GO
ALTER DATABASE [ProTouch] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO
ALTER DATABASE [ProTouch] SET CURSOR_DEFAULT  GLOBAL 
GO
ALTER DATABASE [ProTouch] SET CONCAT_NULL_YIELDS_NULL OFF 
GO
ALTER DATABASE [ProTouch] SET NUMERIC_ROUNDABORT OFF 
GO
ALTER DATABASE [ProTouch] SET QUOTED_IDENTIFIER OFF 
GO
ALTER DATABASE [ProTouch] SET RECURSIVE_TRIGGERS OFF 
GO
ALTER DATABASE [ProTouch] SET  DISABLE_BROKER 
GO
ALTER DATABASE [ProTouch] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO
ALTER DATABASE [ProTouch] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO
ALTER DATABASE [ProTouch] SET TRUSTWORTHY OFF 
GO
ALTER DATABASE [ProTouch] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO
ALTER DATABASE [ProTouch] SET PARAMETERIZATION SIMPLE 
GO
ALTER DATABASE [ProTouch] SET READ_COMMITTED_SNAPSHOT OFF 
GO
ALTER DATABASE [ProTouch] SET HONOR_BROKER_PRIORITY OFF 
GO
ALTER DATABASE [ProTouch] SET RECOVERY SIMPLE 
GO
ALTER DATABASE [ProTouch] SET  MULTI_USER 
GO
ALTER DATABASE [ProTouch] SET PAGE_VERIFY CHECKSUM  
GO
ALTER DATABASE [ProTouch] SET DB_CHAINING OFF 
GO
ALTER DATABASE [ProTouch] SET FILESTREAM( NON_TRANSACTED_ACCESS = OFF ) 
GO
ALTER DATABASE [ProTouch] SET TARGET_RECOVERY_TIME = 0 SECONDS 
GO
USE [ProTouch]
GO
/****** Object:  UserDefinedDataType [dbo].[Address]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[Address] FROM [nvarchar](300) NULL
GO
/****** Object:  UserDefinedDataType [dbo].[Description]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[Description] FROM [nvarchar](500) NULL
GO
/****** Object:  UserDefinedDataType [dbo].[Email]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[Email] FROM [nvarchar](50) NULL
GO
/****** Object:  UserDefinedDataType [dbo].[Location]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[Location] FROM [nvarchar](100) NULL
GO
/****** Object:  UserDefinedDataType [dbo].[Name]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[Name] FROM [nvarchar](50) NULL
GO
/****** Object:  UserDefinedDataType [dbo].[OrgNumber]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[OrgNumber] FROM [nvarchar](16) NULL
GO
/****** Object:  UserDefinedDataType [dbo].[PhoneNumber]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[PhoneNumber] FROM [varchar](30) NULL
GO
/****** Object:  UserDefinedDataType [dbo].[WebAddress]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[WebAddress] FROM [nvarchar](100) NULL
GO
/****** Object:  UserDefinedDataType [dbo].[ZipCode]    Script Date: 14-09-2017 10:36:59 ******/
CREATE TYPE [dbo].[ZipCode] FROM [varchar](7) NULL
GO
USE [ProTouch]
GO
/****** Object:  Sequence [dbo].[SequenceOrderNo]    Script Date: 14-09-2017 10:37:00 ******/
CREATE SEQUENCE [dbo].[SequenceOrderNo] 
 AS [int]
 START WITH 1
 INCREMENT BY 1
 MINVALUE -2147483648
 MAXVALUE 2147483647
 CACHE 
GO
/****** Object:  UserDefinedFunction [dbo].[fn_GetSQLServerBackupDir]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_GetSQLServerBackupDir]() 
RETURNS NVARCHAR(4000) 
AS 
BEGIN 

   DECLARE @path NVARCHAR(4000) 

   EXEC master.dbo.xp_instance_regread 
            N'HKEY_LOCAL_MACHINE', 
            N'Software\Microsoft\MSSQLServer\MSSQLServer',N'BackupDirectory', 
            @path OUTPUT,  
            'no_output' 
   RETURN @path 

END;

--SELECT fn_SQLServerBackupDir = dbo.fn_SQLServerBackupDir();
GO
/****** Object:  Table [dbo].[ApiDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ApiDetails](
	[Id] [int] NOT NULL,
	[ApiUsername] [nvarchar](200) NULL,
	[ApiPassword] [nvarchar](200) NULL,
	[ApiUrl] [nvarchar](200) NOT NULL,
	[ApiHeaderName] [nvarchar](200) NOT NULL,
	[ApiHeaderValuePrefix] [nvarchar](200) NOT NULL,
	[AutoUpdateUrl] [nvarchar](200) NOT NULL,
	[LastSuccessfulStartupDate] [datetime] NULL,
 CONSTRAINT [PK_ApiDetails] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ApplicationLog]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ApplicationLog](
	[ApplicationLogId] [int] IDENTITY(1,1) NOT NULL,
	[LogDateTime] [datetime] NOT NULL,
	[UserId] [int] NULL,
	[PosId] [int] NULL,
	[LogType] [varchar](50) NOT NULL,
	[Message] [nvarchar](500) NOT NULL,
	[Details] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_ErrorLogActivity] PRIMARY KEY CLUSTERED 
(
	[ApplicationLogId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[AppVersionInfo]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AppVersionInfo](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PosId] [int] NOT NULL,
	[InstalledAppVersion] [nvarchar](50) NOT NULL,
	[AvailableAppVersion] [nvarchar](50) NULL,
	[InstalledDBVersion] [nvarchar](50) NULL,
	[AvailableDBVersion] [nvarchar](50) NULL,
	[LastCheckedDateTime] [datetime] NOT NULL,
	[IsUpdateAvailable] [bit] NULL,
	[IsAutoUpdateApplication] [bit] NOT NULL CONSTRAINT [DF_AutoUpdate_IsAutoUpdateApplication]  DEFAULT ((1)),
	[Timer] [int] NULL,
	[MaxAttemptAllowed] [int] NULL CONSTRAINT [MaxAttemptAllowed_Value]  DEFAULT ((2)),
	[AttemptCount] [int] NULL CONSTRAINT [AttemptCount_Value]  DEFAULT ((0)),
 CONSTRAINT [PK_AutoUpdate] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Brands]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Brands](
	[BrandId] [int] NOT NULL,
	[BrandName] [nvarchar](100) NOT NULL,
	[Notes] [nvarchar](max) NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_Brands] PRIMARY KEY CLUSTERED 
(
	[BrandId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[BrandSuppliers]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[BrandSuppliers](
	[BrandSupplierId] [int] IDENTITY(1,1) NOT NULL,
	[BrandId] [int] NOT NULL,
	[SupplierId] [int] NOT NULL,
 CONSTRAINT [PK_BrandSuppliers] PRIMARY KEY CLUSTERED 
(
	[BrandSupplierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[CampaignDiscount]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CampaignDiscount](
	[CampaignDiscountId] [int] NOT NULL,
	[Name] [nvarchar](150) NOT NULL,
	[Comments] [nvarchar](max) NULL,
	[StartAt] [datetime] NULL,
	[EndAt] [datetime] NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[CreatedAt] [datetime] NULL,
	[UpdatedAt] [datetime] NULL,
 CONSTRAINT [PK_CampaignDiscount] PRIMARY KEY CLUSTERED 
(
	[CampaignDiscountId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[CampaignDiscountDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CampaignDiscountDetails](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[CampaignDiscountId] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[VatrateMultiplier] [money] NOT NULL,
	[VatratePercent] [money] NOT NULL,
	[SpecialProductPriceExclVat] [money] NOT NULL,
	[SpecialProductPriceInclVat] [money] NOT NULL,
	[IsTakeaway] [bit] NOT NULL,
	[TakeawayVatrateMultiplier] [money] NULL,
	[TakeawayVatratePercent] [money] NULL,
	[SpecialTaProductPriceExclVat] [money] NULL,
	[SpecialTaProductPriceInclVat] [money] NULL,
 CONSTRAINT [PK_CampaignDiscountDetails] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[CashRegisterCounters]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CashRegisterCounters](
	[CashRegisterCounterId] [int] IDENTITY(1,1) NOT NULL,
	[CounterCode] [nvarchar](100) NOT NULL,
	[Counter] [int] NULL,
	[Value] [money] NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
 CONSTRAINT [PK_CashRegisterCounters] PRIMARY KEY CLUSTERED 
(
	[CashRegisterCounterId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[CashSettlement]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CashSettlement](
	[CashSettlementId] [int] IDENTITY(1,1) NOT NULL,
	[ServerCashSettlementId] [int] NULL,
	[CashSettlementNumber] [int] NULL,
	[OpeningBalance] [money] NULL,
	[CalculatedCashBalance] [money] NULL,
	[CountedCash] [money] NULL,
	[DifferenceInCashBalance] [money] NULL,
	[NightSafeCash] [money] NULL,
	[CashWithdraw] [money] NULL,
	[RemainingCash] [money] NULL,
	[IssuedGiftCards] [money] NULL,
	[IssuedCreditNotes] [money] NULL,
	[IssuedGiftCardsTransactions] [int] NULL,
	[IssuedCreditNotesTransactions] [int] NULL,
	[SignDate] [date] NULL,
	[SignTime] [time](7) NULL,
	[CashSettlementDate] [datetime] NOT NULL,
	[Comments] [nvarchar](max) NULL,
	[PosId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[UserName] [nvarchar](45) NOT NULL,
	[TotalRoundOff] [money] NULL,
	[TerminalResponse] [nvarchar](max) NULL,
	[SumTurnover] [money] NULL,
	[SumVat] [money] NULL,
	[SumReturnTurnover] [money] NULL,
	[SumReturnVat] [money] NULL,
	[SumTerminal] [money] NULL,
	[IsZReport] [bit] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[ServerDateTime] [datetime] NULL,
	[SumTerminalManual] [money] NULL,
	[GrandTotalSales] [money] NULL,
	[GrandTotalReturns] [money] NULL,
	[GrandTotalNet] [money] NULL,
	[SumNetTurnover] [money] NULL,
	[SumNetVat] [money] NULL,
 CONSTRAINT [PK_CashSettlement] PRIMARY KEY CLUSTERED 
(
	[CashSettlementId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Categories]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Categories](
	[CategoryId] [int] NOT NULL,
	[CategoryName] [nvarchar](100) NOT NULL,
	[ParentCategoryId] [int] NULL,
	[SortOrder] [smallint] NULL,
	[CategoryImage] [nvarchar](254) NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_Category] PRIMARY KEY CLUSTERED 
(
	[CategoryId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[CategoryTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CategoryTurnover](
	[CategoryTurnoverId] [int] IDENTITY(1,1) NOT NULL,
	[CashSettlementId] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[CategoryName] [nvarchar](100) NOT NULL,
	[VatRatePercent] [float] NULL,
	[Turnover] [money] NULL,
	[Vat] [money] NULL,
	[TotalProducts] [int] NULL,
 CONSTRAINT [PK_CategoryTurnover] PRIMARY KEY CLUSTERED 
(
	[CategoryTurnoverId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ClientDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ClientDetails](
	[ClientId] [int] NOT NULL,
	[ClientName] [nvarchar](100) NOT NULL,
	[Address] [nvarchar](max) NULL,
	[ZipCode] [varchar](6) NULL,
	[Location] [nvarchar](60) NULL,
	[PhoneNumber] [varchar](45) NULL,
	[Email] [nvarchar](254) NULL,
	[Url] [nvarchar](150) NULL,
	[ClientImage] [nvarchar](254) NULL,
	[Comments] [nvarchar](max) NULL,
 CONSTRAINT [PK_ClientDetails] PRIMARY KEY CLUSTERED 
(
	[ClientId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[ComboProducts]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ComboProducts](
	[ComboProductId] [int] NOT NULL,
	[ParentProductId] [int] NOT NULL,
	[ChildProductId] [int] NOT NULL,
	[ChildProductName] [nvarchar](150) NOT NULL,
	[Quantity] [decimal](10, 2) NOT NULL,
	[VatRateMultiplier] [float] NOT NULL,
	[VatRatePercent] [float] NULL,
	[TakeAwayVatRateMultiplier] [float] NULL,
	[TakeAwayVatRatePercent] [float] NULL,
 CONSTRAINT [PK_ComboProducts] PRIMARY KEY CLUSTERED 
(
	[ComboProductId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ConnectedProductsDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ConnectedProductsDetails](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ProductId] [int] NOT NULL,
	[ConnectedProductId] [int] NOT NULL,
	[IsPerUnit] [bit] NOT NULL,
	[IsForce] [bit] NOT NULL,
	[IsEditable] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[CreatedAt] [datetime] NULL,
	[UpdatedAt] [datetime] NULL,
	[CreatedBy] [int] NULL,
	[UpdatedBy] [int] NULL,
 CONSTRAINT [PK_ConnectedProductsDetails] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[CreditNotes]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CreditNotes](
	[CreditNoteId] [int] IDENTITY(1,1) NOT NULL,
	[OrderId] [int] NOT NULL,
	[CreditNoteNumber] [nvarchar](50) NOT NULL,
	[OriginalAmount] [money] NOT NULL,
	[RestAmount] [money] NOT NULL,
	[ExpiryDate] [datetime] NOT NULL,
	[Title] [nvarchar](100) NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_CreditNotes_CreatedDateTime]  DEFAULT (getdate()),
	[CreatedBy] [int] NOT NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
 CONSTRAINT [PK_CreditNotes] PRIMARY KEY CLUSTERED 
(
	[CreditNoteId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Customers]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Customers](
	[CustomerId] [int] IDENTITY(1,1) NOT NULL,
	[ServerCustomerId] [int] NULL,
	[CustomerName] [nvarchar](90) NOT NULL,
	[Address] [nvarchar](max) NULL,
	[ZipCode] [varchar](6) NULL,
	[Location] [nvarchar](60) NULL,
	[PhoneNumber] [varchar](45) NULL,
	[Email] [nvarchar](254) NULL,
	[CustomerUuid] [uniqueidentifier] NOT NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[CreatedDateTime] [datetime] NULL CONSTRAINT [DF_Customers_CreatedDateTime]  DEFAULT (getdate()),
	[CreatedBy] [int] NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[ServerDateTime] [datetime] NULL,
 CONSTRAINT [PK_Customers] PRIMARY KEY CLUSTERED 
(
	[CustomerId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[DepartmentDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DepartmentDetails](
	[DepartmentId] [int] NOT NULL,
	[DepartmentName] [nvarchar](100) NOT NULL,
	[CompanyName] [nvarchar](100) NOT NULL,
	[Type] [nvarchar](50) NOT NULL,
	[OrgNumber] [nvarchar](50) NULL,
	[Address] [nvarchar](max) NULL,
	[ZipCode] [varchar](6) NULL,
	[Location] [nvarchar](60) NULL,
	[PhoneNumber] [varchar](45) NULL,
	[Email] [nvarchar](254) NULL,
	[Url] [nvarchar](150) NULL,
	[DepartmentImage] [nvarchar](254) NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[IsCurrentDepartment] [bit] NOT NULL,
 CONSTRAINT [PK_DepartmentDetails] PRIMARY KEY CLUSTERED 
(
	[DepartmentId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Folders]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Folders](
	[FolderId] [int] NOT NULL,
	[GroupId] [int] NULL,
	[FolderName] [nvarchar](100) NULL,
	[ParentFolderId] [int] NULL CONSTRAINT [DF_Folders_ParentFolderId]  DEFAULT ((0)),
	[FolderX] [tinyint] NOT NULL,
	[FolderY] [tinyint] NOT NULL,
	[FolderImage] [nvarchar](254) NULL,
	[FolderColor] [varchar](8) NULL,
 CONSTRAINT [PK_Folders] PRIMARY KEY CLUSTERED 
(
	[FolderId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[GiftCards]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GiftCards](
	[GiftCardId] [int] IDENTITY(1,1) NOT NULL,
	[OrderId] [int] NOT NULL,
	[GiftCardNumber] [nvarchar](50) NOT NULL,
	[OriginalAmount] [money] NOT NULL,
	[RestAmount] [money] NOT NULL,
	[ExpiryDate] [datetime] NOT NULL,
	[Title] [nvarchar](100) NULL,
	[CreatedDateTime] [datetime] NULL CONSTRAINT [DF_GiftCards_CreatedDateTime]  DEFAULT (getdate()),
	[CreatedBy] [int] NOT NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
	[Comment] [nvarchar](max) NULL,
	[LineNumber] [int] NULL,
 CONSTRAINT [PK_GiftCards] PRIMARY KEY CLUSTERED 
(
	[GiftCardId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Groups]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Groups](
	[GroupId] [int] NOT NULL,
	[GroupName] [nvarchar](100) NULL,
	[GroupX] [tinyint] NOT NULL,
	[GroupY] [tinyint] NOT NULL,
	[GroupColor] [varchar](8) NULL,
	[IsDefaultSelected] [bit] NOT NULL,
 CONSTRAINT [PK_Groups] PRIMARY KEY CLUSTERED 
(
	[GroupId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[HoldOrders]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HoldOrders](
	[HoldOrderId] [int] IDENTITY(1,1) NOT NULL,
	[OrderReference] [nvarchar](max) NULL,
	[LineNumber] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[ProductName] [nvarchar](150) NOT NULL,
	[Quantity] [decimal](10, 2) NOT NULL,
	[ProductPriceInclVat] [money] NOT NULL,
	[ProductPriceExclVat] [money] NOT NULL,
	[TotalProductPriceInclVat] [money] NOT NULL,
	[TotalProductPriceExclVat] [money] NOT NULL,
	[VatRateMultiplier] [float] NOT NULL,
	[VatRatePercent] [decimal](10, 2) NULL,
	[TotalVatAmount] [money] NOT NULL,
	[DiscountPercentage] [real] NULL,
	[ProductDiscount] [money] NULL,
	[TotalProductDiscount] [money] NULL,
	[PurchasePrice] [money] NULL,
	[SubTotal] [money] NOT NULL,
	[HoldOrderUuid] [uniqueidentifier] NOT NULL,
	[CustomerId] [int] NULL,
	[PosId] [int] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[CreatedBy] [int] NOT NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[IsTakeAway] [bit] NOT NULL,
	[IsPriceChanged] [bit] NOT NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[IsLocked] [bit] NOT NULL,
	[IsBonged] [bit] NOT NULL,
	[IsPaymentDone] [bit] NOT NULL,
	[NormalPriceInclVat] [money] NULL,
	[NormalPriceExclVat] [money] NULL,
	[TakeAwayPriceInclVat] [money] NULL,
	[TakeAwayPriceExclVat] [money] NULL,
	[RowNumberUuid] [uniqueidentifier] NOT NULL,
	[Comment] [nvarchar](max) NULL,
	[IsCombo] [bit] NOT NULL,
	[ComboParentProductId] [int] NULL,
	[CartIndexUuid] [uniqueidentifier] NOT NULL,
	[OldProductPriceInclVat] [money] NULL,
	[OldProductPriceExclVat] [money] NULL,
	[SpecialProductPriceInclVat] [money] NULL,
	[SpecialProductPriceExclVat] [money] NULL,
	[IsCampaign] [bit] NULL,
	[IsConnectedProduct] [bit] NOT NULL,
	[HasConnectedProduct] [bit] NOT NULL,
	[IsPerUnit] [bit] NULL,
	[IsForce] [bit] NULL,
	[IsEditable] [bit] NULL,
	[WeightUnit] [nvarchar](100) NULL,
 CONSTRAINT [PK_HoldOrders] PRIMARY KEY CLUSTERED 
(
	[HoldOrderId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[JournalBasicTypes]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[JournalBasicTypes](
	[BasicTypeId] [int] IDENTITY(1,1) NOT NULL,
	[BasicType] [varchar](4) NOT NULL,
	[EnglishName] [nvarchar](100) NOT NULL,
	[NorwegianDescription] [nvarchar](100) NULL,
 CONSTRAINT [PK_JournalBasicTypes] PRIMARY KEY CLUSTERED 
(
	[BasicTypeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[JournalEventCodes]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[JournalEventCodes](
	[EventCodeId] [int] IDENTITY(1,1) NOT NULL,
	[BasicType] [varchar](4) NULL,
	[BasicId] [varchar](30) NULL,
	[PredefinedBasicId] [varchar](6) NOT NULL,
	[EnglishName] [nvarchar](100) NOT NULL,
	[NorwegianDescription] [nvarchar](100) NULL,
 CONSTRAINT [PK_JournalEventCodes] PRIMARY KEY CLUSTERED 
(
	[EventCodeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[JournalEvents]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[JournalEvents](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[EventId] [varchar](35) NOT NULL,
	[EventType] [varchar](35) NOT NULL,
	[TransId] [varchar](35) NULL,
	[EmpId] [varchar](35) NULL,
	[EventDate] [date] NOT NULL,
	[EventTime] [time](7) NOT NULL,
	[EventText] [nvarchar](max) NULL,
	[PosId] [int] NOT NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[ServerDateTime] [datetime] NULL,
 CONSTRAINT [PK_JournalEvents] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[LoginHistory]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LoginHistory](
	[LoginHistoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[ServerLoginHistoryId] [bigint] NULL,
	[LoginHistoryUuid] [uniqueidentifier] NOT NULL,
	[UserId] [int] NOT NULL,
	[PosId] [int] NOT NULL,
	[LoginDateTime] [datetime] NOT NULL,
	[LogoutDateTime] [datetime] NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[ServerDateTime] [datetime] NULL,
 CONSTRAINT [PK_LoginHistory] PRIMARY KEY CLUSTERED 
(
	[LoginHistoryId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[LogoOption]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LogoOption](
	[LogoOptionId] [nvarchar](50) NOT NULL,
	[LogoOption] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_LogoOption] PRIMARY KEY CLUSTERED 
(
	[LogoOptionId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[NetTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[NetTurnover](
	[NetTurnoverId] [int] IDENTITY(1,1) NOT NULL,
	[CashSettlementId] [int] NOT NULL,
	[VatRatePercent] [float] NOT NULL,
	[VatRateTitle] [nvarchar](100) NOT NULL,
	[Turnover] [money] NULL,
	[Vat] [money] NULL,
 CONSTRAINT [PK_NetTurnover] PRIMARY KEY CLUSTERED 
(
	[NetTurnoverId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[OrderDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OrderDetails](
	[OrderDetailsId] [int] IDENTITY(1,1) NOT NULL,
	[OrderId] [int] NOT NULL,
	[LineNumber] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[ProductName] [nvarchar](150) NOT NULL,
	[Quantity] [decimal](10, 2) NOT NULL,
	[ProductPriceInclVat] [money] NOT NULL,
	[ProductPriceExclVat] [money] NOT NULL,
	[TotalProductPriceInclVat] [money] NOT NULL,
	[TotalProductPriceExclVat] [money] NOT NULL,
	[VatRateMultiplier] [float] NOT NULL,
	[VatRatePercent] [decimal](10, 2) NULL,
	[TotalVatAmount] [money] NOT NULL,
	[DiscountPercentage] [real] NULL,
	[ProductDiscount] [money] NULL,
	[TotalProductDiscount] [money] NULL,
	[PurchasePrice] [money] NULL,
	[SubTotal] [money] NOT NULL,
	[VatAmount] [money] NOT NULL,
	[IsCombo] [bit] NOT NULL,
	[ComboParentProductId] [int] NULL,
	[ChildProductsOnReceipt] [bit] NOT NULL,
	[CartIndexUuid] [uniqueidentifier] NULL,
	[WeightUnit] [nvarchar](100) NULL,
	[Comment] [nvarchar](max) NULL,
	[IsProductDefective] [bit] NULL,
 CONSTRAINT [PK_OrderDetails] PRIMARY KEY CLUSTERED 
(
	[OrderDetailsId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[OrderMisc]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[OrderMisc](
	[OrderMiscId] [int] IDENTITY(1,1) NOT NULL,
	[OrderId] [int] NOT NULL,
	[Type] [varchar](2) NOT NULL,
	[Amount] [money] NOT NULL,
 CONSTRAINT [PK_OrderMisc] PRIMARY KEY CLUSTERED 
(
	[OrderMiscId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Orders]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Orders](
	[OrderId] [int] IDENTITY(1,1) NOT NULL,
	[OrderDateTime] [datetime] NOT NULL,
	[CustomerId] [int] NULL,
	[TotalPriceInclVat] [money] NOT NULL,
	[TotalPriceExclVat] [money] NOT NULL,
	[TotalDiscount] [money] NULL,
	[RoundOff] [money] NULL,
	[TotalPay] [money] NOT NULL,
	[TotalVat] [money] NOT NULL,
	[Comments] [nvarchar](max) NULL,
	[PosId] [int] NOT NULL,
	[ReportingDate] [datetime] NOT NULL,
	[IsReturn] [bit] NOT NULL,
	[ReturnOrderNumber] [varchar](14) NULL,
	[ReceiptNumber] [varchar](14) NULL,
	[UserId] [int] NOT NULL,
	[OrderUuid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Orders_rowguid]  DEFAULT (newid()),
	[ReceiptCopyCount] [tinyint] NULL,
	[ReceiptCopyCountSyncStatus] [tinyint] NOT NULL,
	[AverageDiscountPercentage] [real] NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[ServerDateTime] [datetime] NULL,
	[IsTakeAway] [bit] NOT NULL,
	[OrderReference] [nvarchar](max) NULL,
	[ReceiptType] [nvarchar](10) NULL,
	[ReceiptTypeValue] [nvarchar](254) NULL,
	[ReturnPaymentDescription] [nvarchar](max) NULL,
	[OrderHandlingReceiptNumber] [varchar](14) NULL,
 CONSTRAINT [PK_Orders] PRIMARY KEY CLUSTERED 
(
	[OrderId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[OrderTableMisc]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OrderTableMisc](
	[OrderTableMiscId] [int] IDENTITY(1,1) NOT NULL,
	[OrderId] [int] NOT NULL,
	[RoomId] [int] NOT NULL,
	[TableId] [int] NOT NULL,
 CONSTRAINT [PK_OrderTableMisc] PRIMARY KEY CLUSTERED 
(
	[OrderTableMiscId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ParkedOrders]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ParkedOrders](
	[ParkedOrderId] [int] IDENTITY(1,1) NOT NULL,
	[TableId] [int] NOT NULL,
	[LineNumber] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[ProductName] [nvarchar](150) NOT NULL,
	[Quantity] [decimal](10, 2) NOT NULL,
	[ProductPriceInclVat] [money] NOT NULL,
	[ProductPriceExclVat] [money] NOT NULL,
	[TotalProductPriceInclVat] [money] NOT NULL,
	[TotalProductPriceExclVat] [money] NOT NULL,
	[VatRateMultiplier] [float] NOT NULL,
	[VatRatePercent] [decimal](10, 2) NULL,
	[TotalVatAmount] [money] NOT NULL,
	[DiscountPercentage] [real] NULL,
	[ProductDiscount] [money] NULL,
	[TotalProductDiscount] [money] NULL,
	[PurchasePrice] [money] NULL,
	[SubTotal] [money] NOT NULL,
	[ParkedOrderUuid] [uniqueidentifier] NOT NULL,
	[CustomerId] [int] NULL,
	[PosId] [int] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[CreatedBy] [int] NOT NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[IsTakeAway] [bit] NOT NULL,
	[IsPriceChanged] [bit] NOT NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[IsLocked] [bit] NOT NULL,
	[IsBonged] [bit] NOT NULL,
	[IsPaymentDone] [bit] NOT NULL,
	[NormalPriceInclVat] [money] NULL,
	[NormalPriceExclVat] [money] NULL,
	[TakeAwayPriceInclVat] [money] NULL,
	[TakeAwayPriceExclVat] [money] NULL,
	[RowNumberUuid] [uniqueidentifier] NOT NULL,
	[Comment] [nvarchar](max) NULL,
	[IsCombo] [bit] NOT NULL,
	[ComboParentProductId] [int] NULL,
	[CartIndexUuid] [uniqueidentifier] NOT NULL,
	[OldProductPriceInclVat] [money] NULL,
	[OldProductPriceExclVat] [money] NULL,
	[SpecialProductPriceInclVat] [money] NULL,
	[SpecialProductPriceExclVat] [money] NULL,
	[IsCampaign] [bit] NULL,
	[IsConnectedProduct] [bit] NOT NULL,
	[HasConnectedProduct] [bit] NOT NULL,
	[IsPerUnit] [bit] NULL,
	[IsForce] [bit] NULL,
	[IsEditable] [bit] NULL,
	[WeightUnit] [nvarchar](100) NULL,
 CONSTRAINT [PK_ParkedOrders] PRIMARY KEY CLUSTERED 
(
	[ParkedOrderId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[PaymentMethodTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PaymentMethodTurnover](
	[PaymentMethodTurnoverId] [int] IDENTITY(1,1) NOT NULL,
	[CashSettlementId] [int] NOT NULL,
	[PaymentTypeId] [tinyint] NOT NULL,
	[PaymentType] [nvarchar](60) NOT NULL,
	[Amount] [money] NULL,
	[NumberOfTransactions] [int] NULL,
 CONSTRAINT [PK_PaymentMethodTurnover] PRIMARY KEY CLUSTERED 
(
	[PaymentMethodTurnoverId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Payments]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Payments](
	[PaymentId] [int] IDENTITY(1,1) NOT NULL,
	[OrderId] [int] NOT NULL,
	[PaymentDateTime] [datetime] NOT NULL CONSTRAINT [DF_Payments_PaymentDateTime]  DEFAULT (getdate()),
	[LineNumber] [tinyint] NOT NULL,
	[PaymentTypeId] [tinyint] NOT NULL,
	[Amount] [money] NOT NULL,
	[PaidAmount] [money] NULL,
	[TerminalOperator] [nvarchar](50) NULL,
	[TerminalText] [nvarchar](max) NULL,
	[ReferenceNumber] [nvarchar](50) NULL,
 CONSTRAINT [PK_Payments] PRIMARY KEY CLUSTERED 
(
	[PaymentId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[PaymentTypes]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[PaymentTypes](
	[PaymentTypeId] [tinyint] NOT NULL,
	[PaymentType] [nvarchar](60) NOT NULL,
	[Comments] [nvarchar](255) NOT NULL,
	[PaymentMethodName] [nvarchar](60) NOT NULL,
	[PaymentMethodImage] [varchar](254) NULL,
	[IsDefaultPaymentMethod] [bit] NOT NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[IsReturnPaymentMethod] [bit] NOT NULL,
 CONSTRAINT [PK_PaymentTypes] PRIMARY KEY CLUSTERED 
(
	[PaymentTypeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Permissions]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Permissions](
	[PermissionId] [int] NOT NULL,
	[PermissionName] [nvarchar](1000) NOT NULL,
	[IsActive] [bit] NOT NULL,
 CONSTRAINT [PK_Permissions] PRIMARY KEY CLUSTERED 
(
	[PermissionId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[PosDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[PosDetails](
	[PosId] [int] NOT NULL,
	[PosName] [nvarchar](75) NOT NULL,
	[PosNumber] [varchar](10) NOT NULL,
	[DepartmentId] [int] NOT NULL,
	[UniqueKey] [nvarchar](50) NULL,
	[Comments] [nvarchar](max) NULL,
	[PosDesign] [nvarchar](50) NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_PosDetails] PRIMARY KEY CLUSTERED 
(
	[PosId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[PosModules]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PosModules](
	[ModuleId] [int] NOT NULL,
	[ModuleName] [nvarchar](90) NOT NULL,
	[ModuleKey] [nvarchar](50) NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_Modules] PRIMARY KEY CLUSTERED 
(
	[ModuleId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[PosSettings]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PosSettings](
	[PosSettingsId] [smallint] IDENTITY(1,1) NOT NULL,
	[PosId] [int] NOT NULL,
	[ReceiptAction] [nvarchar](50) NULL,
	[ReceiptLogo] [nvarchar](250) NULL,
	[UseCustomerDisplay] [bit] NOT NULL,
	[CustomerDisplayLine1] [nvarchar](20) NULL,
	[CustomerDisplayLine2] [nvarchar](20) NULL,
	[AskPinNumber] [bit] NOT NULL,
	[IsAllowAddCustomer] [bit] NOT NULL,
	[ReceiptBottomText] [nvarchar](max) NULL,
	[TerminalOperator] [nvarchar](50) NULL,
	[PointConnectionType] [nvarchar](50) NULL,
	[PointConnectionValue] [nvarchar](50) NULL,
	[PointLogLevel] [int] NULL,
	[CustomerDisplayModel] [nvarchar](50) NULL,
	[CustomerDisplayComPort] [nvarchar](10) NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_PosSettings_CreatedDateTime]  DEFAULT (getdate()),
	[CreatedBy] [int] NOT NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[ServerDateTime] [datetime] NULL,
	[KitchenPrinterIp1] [nvarchar](50) NULL,
	[GiftCardBottomText] [nvarchar](max) NULL,
	[CreditNotesBottomText] [nvarchar](max) NULL,
	[IsAllowChangePrice] [bit] NOT NULL,
	[IsDisplayCostPrice] [bit] NOT NULL,
	[LogoOption] [nvarchar](50) NULL,
	[AppVersion] [nvarchar](50) NOT NULL,
	[IsInvoicePayment] [bit] NOT NULL,
	[KitchenPrinterIp2] [nvarchar](50) NULL,
	[KitchenPrinterIp3] [nvarchar](50) NULL,
	[KitchenPrinterIp4] [nvarchar](50) NULL,
	[KitchenPrinterIp5] [nvarchar](50) NULL,
	[DisableZReportIfActiveTable] [bit] NOT NULL,
	[IsIntegratedTerminal] [bit] NOT NULL,
	[IsManualTerminal] [bit] NOT NULL,
	[IsIntegratedDrawer] [bit] NOT NULL,
	[ReceiptPrinterIp] [nvarchar](50) NULL,
	[ReceiptPrinterPort] [nvarchar](50) NULL,
	[WeightMachineAvailable] [bit] NOT NULL,
	[WeightMachineComPort] [nvarchar](10) NULL,
	[UseOsk] [bit] NOT NULL,
	[DisableZReportIfHoldOrder] [bit] NOT NULL,
	[CashDrawerName] [nvarchar](50) NULL,
	[DrawerConnectionType] [nvarchar](50) NULL,
	[QuickPayMethod] [nvarchar](50) NULL,
	[IsPrintNGo] [bit] NOT NULL,
 CONSTRAINT [PK_PosSettings] PRIMARY KEY CLUSTERED 
(
	[PosSettingsId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Printers]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Printers](
	[PrinterId] [int] NOT NULL,
	[PrinterName] [dbo].[Name] NOT NULL,
	[IP] [varchar](15) NOT NULL,
	[Port] [int] NOT NULL,
 CONSTRAINT [PK_Printers] PRIMARY KEY CLUSTERED 
(
	[PrinterId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[ProductKitchenPrinters]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProductKitchenPrinters](
	[ProductKitchenPrinterId] [int] IDENTITY(1,1) NOT NULL,
	[ProductId] [int] NOT NULL,
	[KitchenPrinterId] [int] NOT NULL,
 CONSTRAINT [PK_ProductKitchenPrinters] PRIMARY KEY CLUSTERED 
(
	[ProductKitchenPrinterId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ProductPrinters]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProductPrinters](
	[ProductPrinterId] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[PrinterId] [int] NOT NULL,
 CONSTRAINT [PK_ItemPrinters] PRIMARY KEY CLUSTERED 
(
	[ProductPrinterId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Products]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Products](
	[ProductId] [int] NOT NULL,
	[ProductName] [nvarchar](150) NOT NULL,
	[Barcode] [nvarchar](45) NULL,
	[ProductNumber] [nvarchar](50) NOT NULL,
	[CategoryId] [int] NOT NULL,
	[VatRateId] [int] NOT NULL,
	[PriceExclVat] [money] NOT NULL,
	[PriceInclVat] [money] NOT NULL,
	[PurchasePrice] [money] NULL,
	[Description] [nvarchar](max) NULL,
	[IsTakeAway] [bit] NOT NULL,
	[TakeAwayPriceExclVat] [money] NULL,
	[TakeAwayPriceInclVat] [money] NULL,
	[TakeAwayVatRateId] [int] NULL,
	[HasVariant] [bit] NOT NULL,
	[BrandId] [int] NULL,
	[StockControl] [bit] NOT NULL,
	[ProductUnitId] [int] NULL,
	[WeightUnitId] [int] NULL,
	[Weight] [real] NULL,
	[ProductImage] [nvarchar](254) NULL,
	[ShowOnWeb] [bit] NOT NULL,
	[ParentId] [bigint] NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[IsCombo] [bit] NOT NULL,
	[PrintOnBong] [bit] NOT NULL,
	[ChildProductsOnReceipt] [bit] NOT NULL,
	[RequireWeight] [bit] NOT NULL,
	[IsInvoiceFeeProduct] [bit] NOT NULL,
 CONSTRAINT [PK_Items] PRIMARY KEY CLUSTERED 
(
	[ProductId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ProductSoldDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProductSoldDetails](
	[ProductId] [int] NOT NULL,
	[LastSold] [datetime] NOT NULL,
	[LastSoldQuanity] [decimal](10, 2) NOT NULL,
	[LastSoldOrderId] [int] NOT NULL,
 CONSTRAINT [PK_ItemSoldDetails] PRIMARY KEY CLUSTERED 
(
	[ProductId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ProductStock]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProductStock](
	[ProductStockId] [int] IDENTITY(1,1) NOT NULL,
	[ProductId] [int] NOT NULL,
	[InStock] [decimal](10, 2) NOT NULL,
	[UpdatedDateTime] [datetime] NULL,
 CONSTRAINT [PK_ItemStock] PRIMARY KEY CLUSTERED 
(
	[ProductStockId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ProductStockUpdate]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProductStockUpdate](
	[ProductStockUpdateId] [int] IDENTITY(1,1) NOT NULL,
	[ProductId] [int] NOT NULL,
	[StockQuantity] [decimal](10, 0) NOT NULL,
	[CreateDateTime] [datetime] NOT NULL,
 CONSTRAINT [PK_ItemStockUpdate] PRIMARY KEY CLUSTERED 
(
	[ProductStockUpdateId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ProductSuppliers]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProductSuppliers](
	[ProductSupplierId] [int] IDENTITY(1,1) NOT NULL,
	[ProductId] [int] NOT NULL,
	[SupplierId] [int] NOT NULL,
 CONSTRAINT [PK_ItemSuppliers] PRIMARY KEY CLUSTERED 
(
	[ProductSupplierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ProductUnit]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProductUnit](
	[ProductUnitId] [int] NOT NULL,
	[Unit] [nvarchar](100) NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_product_unit] PRIMARY KEY CLUSTERED 
(
	[ProductUnitId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ProductVariants]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ProductVariants](
	[ProductVariantId] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[VariantGroupId] [int] NOT NULL,
	[VariantValueId] [int] NOT NULL,
 CONSTRAINT [PK_product_variants] PRIMARY KEY CLUSTERED 
(
	[ProductVariantId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ReceiptAction]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReceiptAction](
	[ReceiptActionId] [nvarchar](50) NOT NULL,
	[ReceiptAction] [nvarchar](50) NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_ReceiptAction_CreatedDateTime]  DEFAULT (getdate()),
	[CreatedBy] [int] NOT NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
 CONSTRAINT [PK_ReceiptAction] PRIMARY KEY CLUSTERED 
(
	[ReceiptActionId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ReturnVatTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReturnVatTurnover](
	[ReturnVatTurnoverId] [int] IDENTITY(1,1) NOT NULL,
	[CashSettlementId] [int] NOT NULL,
	[VatRatePercent] [float] NOT NULL,
	[VatRateTitle] [nvarchar](100) NOT NULL,
	[Turnover] [money] NULL,
	[Vat] [money] NULL,
	[TotalProducts] [int] NULL,
 CONSTRAINT [PK_ReturnVatTurnover] PRIMARY KEY CLUSTERED 
(
	[ReturnVatTurnoverId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Rooms]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Rooms](
	[RoomId] [int] NOT NULL,
	[RoomName] [nvarchar](50) NOT NULL,
	[SortOrder] [int] NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_Rooms] PRIMARY KEY CLUSTERED 
(
	[RoomId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[SASettings]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[SASettings](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Code] [nvarchar](255) NOT NULL,
	[IsActive] [bit] NOT NULL,
	[IsBoSetting] [bit] NOT NULL,
	[Value] [varchar](254) NULL,
 CONSTRAINT [PK_SASettings] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[ServerParkedOrders]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ServerParkedOrders](
	[ServerParkedOrderId] [int] IDENTITY(1,1) NOT NULL,
	[TableId] [int] NOT NULL,
	[LineNumber] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[ProductName] [nvarchar](150) NOT NULL,
	[Quantity] [decimal](10, 2) NOT NULL,
	[ProductPriceInclVat] [money] NOT NULL,
	[ProductPriceExclVat] [money] NOT NULL,
	[TotalProductPriceInclVat] [money] NOT NULL,
	[TotalProductPriceExclVat] [money] NOT NULL,
	[VatRateMultiplier] [float] NOT NULL,
	[VatRatePercent] [decimal](10, 2) NULL,
	[TotalVatAmount] [money] NOT NULL,
	[DiscountPercentage] [real] NULL,
	[ProductDiscount] [money] NULL,
	[TotalProductDiscount] [money] NULL,
	[PurchasePrice] [money] NULL,
	[SubTotal] [money] NOT NULL,
	[ParkedOrderUuid] [uniqueidentifier] NOT NULL,
	[CustomerId] [int] NULL,
	[PosId] [int] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[CreatedBy] [int] NOT NULL,
	[UpdatedDateTime] [datetime] NULL,
	[UpdatedBy] [int] NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[IsTakeAway] [bit] NOT NULL,
	[IsPriceChanged] [bit] NOT NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[IsLocked] [bit] NOT NULL,
	[IsBonged] [bit] NOT NULL,
	[IsPaymentDone] [bit] NOT NULL,
	[NormalPriceInclVat] [money] NULL,
	[NormalPriceExclVat] [money] NULL,
	[TakeAwayPriceInclVat] [money] NULL,
	[TakeAwayPriceExclVat] [money] NULL,
	[RowNumberUuid] [uniqueidentifier] NOT NULL,
	[Comment] [nvarchar](max) NULL,
	[IsCombo] [bit] NOT NULL,
	[ComboParentProductId] [int] NULL,
	[CartIndexUuid] [uniqueidentifier] NOT NULL,
	[OldProductPriceInclVat] [money] NULL,
	[OldProductPriceExclVat] [money] NULL,
	[SpecialProductPriceInclVat] [money] NULL,
	[SpecialProductPriceExclVat] [money] NULL,
	[IsCampaign] [bit] NULL,
	[IsConnectedProduct] [bit] NOT NULL,
	[HasConnectedProduct] [bit] NOT NULL,
	[IsPerUnit] [bit] NULL,
	[IsForce] [bit] NULL,
	[IsEditable] [bit] NULL,
	[WeightUnit] [nvarchar](100) NULL,
 CONSTRAINT [PK_ServerParkedOrders] PRIMARY KEY CLUSTERED 
(
	[ServerParkedOrderId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[SupplierContactPersons]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[SupplierContactPersons](
	[Id] [int] NOT NULL,
	[SupplierId] [int] NOT NULL,
	[SupplierContactName] [nvarchar](50) NOT NULL,
	[PhoneNumber] [varchar](45) NULL,
	[Email] [nvarchar](254) NULL,
 CONSTRAINT [PK_supplier_contact_person] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Suppliers]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Suppliers](
	[SupplierId] [int] NOT NULL,
	[OrgNumber] [nvarchar](50) NULL,
	[SupplierName] [nvarchar](90) NOT NULL,
	[Address] [nvarchar](max) NULL,
	[ZipCode] [varchar](6) NULL,
	[Location] [nvarchar](60) NULL,
	[PhoneNumber] [varchar](45) NULL,
	[Email] [nvarchar](254) NULL,
	[Url] [nvarchar](150) NULL,
	[CustomerNumber] [nvarchar](30) NULL,
	[Notes] [nvarchar](max) NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_suppliers] PRIMARY KEY CLUSTERED 
(
	[SupplierId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[SupportContactDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[SupportContactDetails](
	[SupportContactDetailsId] [int] NOT NULL,
	[SupportName] [nvarchar](50) NOT NULL,
	[Email] [nvarchar](254) NOT NULL,
	[Phone] [varchar](45) NOT NULL,
 CONSTRAINT [PK_SupportContactDetails] PRIMARY KEY CLUSTERED 
(
	[SupportContactDetailsId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[SyncDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SyncDetails](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[GroupName] [nvarchar](50) NOT NULL,
	[SyncOrder] [smallint] NOT NULL,
	[TableName] [nvarchar](50) NOT NULL,
	[LastSyncDate] [datetime] NULL,
 CONSTRAINT [PK_SyncDetails] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Tables]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Tables](
	[TableId] [int] NOT NULL,
	[TableNumber] [int] NOT NULL,
	[RoomId] [int] NOT NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_Tables] PRIMARY KEY CLUSTERED 
(
	[TableId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[TeamViewerSupportRequests]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[TeamViewerSupportRequests](
	[TeamViewerSupportRequestId] [int] IDENTITY(1,1) NOT NULL,
	[UserName] [nvarchar](50) NULL,
	[Email] [nvarchar](254) NULL,
	[ProblemDescription] [nvarchar](max) NULL,
	[PosId] [int] NULL,
	[UserLink] [varchar](50) NULL,
	[SessionId] [varchar](12) NULL,
	[GroupId] [varchar](20) NULL,
	[RequestedDateTime] [datetime] NULL,
	[ValidUntil] [datetime] NOT NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_TeamViewerSupportRequests] PRIMARY KEY CLUSTERED 
(
	[TeamViewerSupportRequestId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[TempFolders]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[TempFolders](
	[FolderId] [int] NOT NULL,
	[GroupId] [int] NULL,
	[FolderName] [nvarchar](100) NULL,
	[ParentFolderId] [int] NULL CONSTRAINT [DF_TempFolders_ParentFolderId]  DEFAULT ((0)),
	[FolderX] [tinyint] NOT NULL,
	[FolderY] [tinyint] NOT NULL,
	[FolderImage] [nvarchar](254) NULL,
	[FolderColor] [varchar](8) NULL,
 CONSTRAINT [PK_TempFolders] PRIMARY KEY CLUSTERED 
(
	[FolderId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[TempGroups]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[TempGroups](
	[GroupId] [int] NOT NULL,
	[GroupName] [nvarchar](100) NULL,
	[GroupX] [tinyint] NOT NULL,
	[GroupY] [tinyint] NOT NULL,
	[GroupColor] [varchar](8) NULL,
	[IsDefaultSelected] [bit] NOT NULL,
 CONSTRAINT [PK_TempGroups] PRIMARY KEY CLUSTERED 
(
	[GroupId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[TempRooms]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TempRooms](
	[RoomId] [int] NOT NULL,
	[RoomName] [nvarchar](50) NOT NULL,
	[SortOrder] [int] NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_TempRooms] PRIMARY KEY CLUSTERED 
(
	[RoomId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[TempTables]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TempTables](
	[TableId] [int] NOT NULL,
	[TableNumber] [int] NOT NULL,
	[RoomId] [int] NOT NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_TempTables] PRIMARY KEY CLUSTERED 
(
	[TableId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[TempTileProducts]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TempTileProducts](
	[TileProductsId] [int] NOT NULL,
	[TileId] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[Quantity] [decimal](10, 2) NOT NULL,
 CONSTRAINT [PK_TempTileItems] PRIMARY KEY CLUSTERED 
(
	[TileProductsId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[TempTiles]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[TempTiles](
	[TileId] [int] NOT NULL,
	[GroupId] [int] NULL,
	[FolderId] [int] NULL,
	[TileName] [nvarchar](100) NULL,
	[TileX] [tinyint] NOT NULL,
	[TileY] [tinyint] NOT NULL,
	[TileImage] [nvarchar](254) NULL,
	[TileColor] [varchar](8) NULL,
 CONSTRAINT [PK_TempTiles] PRIMARY KEY CLUSTERED 
(
	[TileId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[TileProducts]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TileProducts](
	[TileProductsId] [int] NOT NULL,
	[TileId] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[Quantity] [decimal](10, 2) NOT NULL,
 CONSTRAINT [PK_TileItems] PRIMARY KEY CLUSTERED 
(
	[TileProductsId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Tiles]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Tiles](
	[TileId] [int] NOT NULL,
	[GroupId] [int] NULL,
	[FolderId] [int] NULL,
	[TileName] [nvarchar](100) NULL,
	[TileX] [tinyint] NOT NULL,
	[TileY] [tinyint] NOT NULL,
	[TileImage] [nvarchar](254) NULL,
	[TileColor] [varchar](8) NULL,
 CONSTRAINT [PK_Tiles] PRIMARY KEY CLUSTERED 
(
	[TileId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[UserGroupPermissions]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserGroupPermissions](
	[UserGroupPermissionId] [int] IDENTITY(1,1) NOT NULL,
	[UserGroupId] [int] NOT NULL,
	[PermissionId] [int] NOT NULL,
 CONSTRAINT [PK_UserGroupPermissions] PRIMARY KEY CLUSTERED 
(
	[UserGroupPermissionId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[UserGroups]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserGroups](
	[UserGroupId] [int] NOT NULL,
	[UserGroupName] [nvarchar](70) NOT NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_UserGroups] PRIMARY KEY CLUSTERED 
(
	[UserGroupId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Users]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Users](
	[UserId] [int] NOT NULL,
	[FirstName] [nvarchar](65) NOT NULL,
	[LastName] [nvarchar](65) NOT NULL,
	[NameOnReceipt] [nvarchar](50) NOT NULL,
	[DepartmentId] [int] NOT NULL,
	[UserGroupId] [int] NOT NULL,
	[SSN] [nvarchar](12) NULL,
	[AccountNumber] [nvarchar](13) NULL,
	[PinCode] [varchar](6) NOT NULL,
	[CardNumber] [nvarchar](13) NULL,
	[Position] [nvarchar](45) NULL,
	[Address] [nvarchar](max) NULL,
	[ZipCode] [nvarchar](6) NULL,
	[Location] [nvarchar](60) NULL,
	[PhoneNumber] [nvarchar](45) NULL,
	[Email] [nvarchar](254) NULL,
	[Url] [nvarchar](150) NULL,
	[Comment] [nvarchar](max) NULL,
	[UserName] [nvarchar](45) NOT NULL,
	[Password] [nvarchar](90) NOT NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[UserImage] [nvarchar](254) NULL,
 CONSTRAINT [PK_Users] PRIMARY KEY CLUSTERED 
(
	[UserId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[UserTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserTurnover](
	[UserTurnoverId] [int] IDENTITY(1,1) NOT NULL,
	[CashSettlementId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[Name] [nvarchar](45) NOT NULL,
	[Turnover] [money] NULL,
	[Vat] [money] NULL,
 CONSTRAINT [PK_UserTurnover] PRIMARY KEY CLUSTERED 
(
	[UserTurnoverId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[VariantGroups]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[VariantGroups](
	[VariantGroupId] [int] NOT NULL,
	[VariantGroupName] [nvarchar](100) NOT NULL,
	[IsDeleted] [bit] NOT NULL,
	[IsActive] [bit] NOT NULL,
 CONSTRAINT [PK_VariantGroups] PRIMARY KEY CLUSTERED 
(
	[VariantGroupId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[VariantGroupValues]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[VariantGroupValues](
	[VariantValueId] [int] NOT NULL,
	[VariantValue] [nvarchar](100) NOT NULL,
	[VariantGroupId] [int] NOT NULL,
	[IsActive] [bit] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_Variants] PRIMARY KEY CLUSTERED 
(
	[VariantValueId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[VatRate]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[VatRate](
	[VatRateId] [int] NOT NULL,
	[VatRateTitle] [nvarchar](100) NOT NULL,
	[VatRateMultiplier] [float] NOT NULL,
	[VatRatePercent] [float] NOT NULL,
	[IsDeleted] [bit] NOT NULL,
 CONSTRAINT [PK_VatRate] PRIMARY KEY CLUSTERED 
(
	[VatRateId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[VatTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[VatTurnover](
	[VatTurnoverId] [int] IDENTITY(1,1) NOT NULL,
	[CashSettlementId] [int] NOT NULL,
	[VatRatePercent] [float] NOT NULL,
	[VatRateTitle] [nvarchar](100) NOT NULL,
	[Turnover] [money] NULL,
	[Vat] [money] NULL,
 CONSTRAINT [PK_VatTurnover] PRIMARY KEY CLUSTERED 
(
	[VatTurnoverId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Waste]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Waste](
	[WasteId] [int] IDENTITY(1,1) NOT NULL,
	[ProductId] [int] NOT NULL,
	[ProductName] [nvarchar](150) NOT NULL,
	[Quantity] [decimal](10, 2) NOT NULL,
	[WasteType] [varchar](50) NOT NULL,
	[Comment] [nvarchar](max) NOT NULL,
	[PurchasePrice] [money] NOT NULL,
	[OrderId] [int] NULL,
	[OrderUuid] [uniqueidentifier] NULL CONSTRAINT [DF_Waste_OrderUuid]  DEFAULT (newid()),
	[PosId] [int] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[CreatedBy] [int] NOT NULL,
	[FailSyncAttemptCount] [tinyint] NULL,
	[IsSyncSuccess] [bit] NOT NULL,
	[SyncAttemptDate] [datetime] NULL,
	[ServerDateTime] [datetime] NULL,
 CONSTRAINT [PK_Waste] PRIMARY KEY CLUSTERED 
(
	[WasteId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[ZipCode]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ZipCode](
	[Id] [int] NOT NULL,
	[ZipCode] [nvarchar](10) NOT NULL,
	[City] [nvarchar](60) NOT NULL,
 CONSTRAINT [PK_ZipCode] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ZReportCounters]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ZReportCounters](
	[ZReportCounterId] [int] IDENTITY(1,1) NOT NULL,
	[CashSettlementId] [int] NOT NULL,
	[CounterCode] [nvarchar](100) NOT NULL,
	[Counter] [int] NULL,
	[Value] [money] NULL,
 CONSTRAINT [PK_ZReportCounters] PRIMARY KEY CLUSTERED 
(
	[ZReportCounterId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
ALTER TABLE [dbo].[ApplicationLog]  WITH CHECK ADD  CONSTRAINT [FK_ErrorLogActivity_pos] FOREIGN KEY([PosId])
REFERENCES [dbo].[PosDetails] ([PosId])
GO
ALTER TABLE [dbo].[ApplicationLog] CHECK CONSTRAINT [FK_ErrorLogActivity_pos]
GO
ALTER TABLE [dbo].[ApplicationLog]  WITH CHECK ADD  CONSTRAINT [FK_ErrorLogActivity_Users] FOREIGN KEY([UserId])
REFERENCES [dbo].[Users] ([UserId])
GO
ALTER TABLE [dbo].[ApplicationLog] CHECK CONSTRAINT [FK_ErrorLogActivity_Users]
GO
ALTER TABLE [dbo].[AppVersionInfo]  WITH CHECK ADD  CONSTRAINT [FK_AppVersionInfo_PosDetails] FOREIGN KEY([PosId])
REFERENCES [dbo].[PosDetails] ([PosId])
GO
ALTER TABLE [dbo].[AppVersionInfo] CHECK CONSTRAINT [FK_AppVersionInfo_PosDetails]
GO
ALTER TABLE [dbo].[BrandSuppliers]  WITH CHECK ADD  CONSTRAINT [FK_brand_supplier_brand] FOREIGN KEY([BrandId])
REFERENCES [dbo].[Brands] ([BrandId])
GO
ALTER TABLE [dbo].[BrandSuppliers] CHECK CONSTRAINT [FK_brand_supplier_brand]
GO
ALTER TABLE [dbo].[BrandSuppliers]  WITH CHECK ADD  CONSTRAINT [FK_brand_supplier_suppliers] FOREIGN KEY([SupplierId])
REFERENCES [dbo].[Suppliers] ([SupplierId])
GO
ALTER TABLE [dbo].[BrandSuppliers] CHECK CONSTRAINT [FK_brand_supplier_suppliers]
GO
ALTER TABLE [dbo].[CampaignDiscountDetails]  WITH CHECK ADD  CONSTRAINT [FK_CampaignDiscountDetails_CampaignDiscount] FOREIGN KEY([CampaignDiscountId])
REFERENCES [dbo].[CampaignDiscount] ([CampaignDiscountId])
GO
ALTER TABLE [dbo].[CampaignDiscountDetails] CHECK CONSTRAINT [FK_CampaignDiscountDetails_CampaignDiscount]
GO
ALTER TABLE [dbo].[CampaignDiscountDetails]  WITH CHECK ADD  CONSTRAINT [FK_CampaignDiscountDetails_Products] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[CampaignDiscountDetails] CHECK CONSTRAINT [FK_CampaignDiscountDetails_Products]
GO
ALTER TABLE [dbo].[CashSettlement]  WITH CHECK ADD  CONSTRAINT [FK_CashSettlement_PosDetails] FOREIGN KEY([PosId])
REFERENCES [dbo].[PosDetails] ([PosId])
GO
ALTER TABLE [dbo].[CashSettlement] CHECK CONSTRAINT [FK_CashSettlement_PosDetails]
GO
ALTER TABLE [dbo].[CashSettlement]  WITH CHECK ADD  CONSTRAINT [FK_CashSettlement_Users] FOREIGN KEY([UserId])
REFERENCES [dbo].[Users] ([UserId])
GO
ALTER TABLE [dbo].[CashSettlement] CHECK CONSTRAINT [FK_CashSettlement_Users]
GO
ALTER TABLE [dbo].[CategoryTurnover]  WITH CHECK ADD  CONSTRAINT [FK_CategoryTurnover_CashSettlement] FOREIGN KEY([CashSettlementId])
REFERENCES [dbo].[CashSettlement] ([CashSettlementId])
GO
ALTER TABLE [dbo].[CategoryTurnover] CHECK CONSTRAINT [FK_CategoryTurnover_CashSettlement]
GO
ALTER TABLE [dbo].[CategoryTurnover]  WITH CHECK ADD  CONSTRAINT [FK_CategoryTurnover_Category] FOREIGN KEY([CategoryId])
REFERENCES [dbo].[Categories] ([CategoryId])
GO
ALTER TABLE [dbo].[CategoryTurnover] CHECK CONSTRAINT [FK_CategoryTurnover_Category]
GO
ALTER TABLE [dbo].[ComboProducts]  WITH CHECK ADD  CONSTRAINT [FK_ComboProducts_Products] FOREIGN KEY([ParentProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[ComboProducts] CHECK CONSTRAINT [FK_ComboProducts_Products]
GO
ALTER TABLE [dbo].[ConnectedProductsDetails]  WITH CHECK ADD  CONSTRAINT [FK_ConnectedProductsDetails_ConnectedProductsDetails] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[ConnectedProductsDetails] CHECK CONSTRAINT [FK_ConnectedProductsDetails_ConnectedProductsDetails]
GO
ALTER TABLE [dbo].[ConnectedProductsDetails]  WITH CHECK ADD  CONSTRAINT [FK_ConnectedProductsDetails_Products] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[ConnectedProductsDetails] CHECK CONSTRAINT [FK_ConnectedProductsDetails_Products]
GO
ALTER TABLE [dbo].[LoginHistory]  WITH CHECK ADD  CONSTRAINT [FK_LoginHistory_pos] FOREIGN KEY([PosId])
REFERENCES [dbo].[PosDetails] ([PosId])
GO
ALTER TABLE [dbo].[LoginHistory] CHECK CONSTRAINT [FK_LoginHistory_pos]
GO
ALTER TABLE [dbo].[LoginHistory]  WITH CHECK ADD  CONSTRAINT [FK_LoginHistory_Users] FOREIGN KEY([UserId])
REFERENCES [dbo].[Users] ([UserId])
GO
ALTER TABLE [dbo].[LoginHistory] CHECK CONSTRAINT [FK_LoginHistory_Users]
GO
ALTER TABLE [dbo].[OrderDetails]  WITH CHECK ADD  CONSTRAINT [FK_OrderDetails_Items] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[OrderDetails] CHECK CONSTRAINT [FK_OrderDetails_Items]
GO
ALTER TABLE [dbo].[OrderDetails]  WITH CHECK ADD  CONSTRAINT [FK_OrderDetails_Orders] FOREIGN KEY([OrderId])
REFERENCES [dbo].[Orders] ([OrderId])
GO
ALTER TABLE [dbo].[OrderDetails] CHECK CONSTRAINT [FK_OrderDetails_Orders]
GO
ALTER TABLE [dbo].[OrderMisc]  WITH CHECK ADD  CONSTRAINT [FK_OrderMisc_Orders] FOREIGN KEY([OrderId])
REFERENCES [dbo].[Orders] ([OrderId])
GO
ALTER TABLE [dbo].[OrderMisc] CHECK CONSTRAINT [FK_OrderMisc_Orders]
GO
ALTER TABLE [dbo].[Orders]  WITH CHECK ADD  CONSTRAINT [FK_Orders_Customers] FOREIGN KEY([CustomerId])
REFERENCES [dbo].[Customers] ([CustomerId])
GO
ALTER TABLE [dbo].[Orders] CHECK CONSTRAINT [FK_Orders_Customers]
GO
ALTER TABLE [dbo].[Orders]  WITH CHECK ADD  CONSTRAINT [FK_Orders_pos] FOREIGN KEY([PosId])
REFERENCES [dbo].[PosDetails] ([PosId])
GO
ALTER TABLE [dbo].[Orders] CHECK CONSTRAINT [FK_Orders_pos]
GO
ALTER TABLE [dbo].[Orders]  WITH CHECK ADD  CONSTRAINT [FK_Orders_Users] FOREIGN KEY([UserId])
REFERENCES [dbo].[Users] ([UserId])
GO
ALTER TABLE [dbo].[Orders] CHECK CONSTRAINT [FK_Orders_Users]
GO
ALTER TABLE [dbo].[Payments]  WITH CHECK ADD  CONSTRAINT [FK_Payments_PaymentTypes] FOREIGN KEY([PaymentTypeId])
REFERENCES [dbo].[PaymentTypes] ([PaymentTypeId])
GO
ALTER TABLE [dbo].[Payments] CHECK CONSTRAINT [FK_Payments_PaymentTypes]
GO
ALTER TABLE [dbo].[PosDetails]  WITH CHECK ADD  CONSTRAINT [FK_PosDetails_DepartmentDetails] FOREIGN KEY([DepartmentId])
REFERENCES [dbo].[DepartmentDetails] ([DepartmentId])
GO
ALTER TABLE [dbo].[PosDetails] CHECK CONSTRAINT [FK_PosDetails_DepartmentDetails]
GO
ALTER TABLE [dbo].[PosSettings]  WITH CHECK ADD  CONSTRAINT [FK_PosSettings_pos] FOREIGN KEY([PosId])
REFERENCES [dbo].[PosDetails] ([PosId])
GO
ALTER TABLE [dbo].[PosSettings] CHECK CONSTRAINT [FK_PosSettings_pos]
GO
ALTER TABLE [dbo].[ProductPrinters]  WITH CHECK ADD  CONSTRAINT [FK_ItemPrinters_Items] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[ProductPrinters] CHECK CONSTRAINT [FK_ItemPrinters_Items]
GO
ALTER TABLE [dbo].[ProductPrinters]  WITH CHECK ADD  CONSTRAINT [FK_ItemPrinters_Printers] FOREIGN KEY([PrinterId])
REFERENCES [dbo].[Printers] ([PrinterId])
GO
ALTER TABLE [dbo].[ProductPrinters] CHECK CONSTRAINT [FK_ItemPrinters_Printers]
GO
ALTER TABLE [dbo].[Products]  WITH CHECK ADD  CONSTRAINT [FK_Items_Brands] FOREIGN KEY([BrandId])
REFERENCES [dbo].[Brands] ([BrandId])
GO
ALTER TABLE [dbo].[Products] CHECK CONSTRAINT [FK_Items_Brands]
GO
ALTER TABLE [dbo].[Products]  WITH CHECK ADD  CONSTRAINT [FK_Items_Category] FOREIGN KEY([CategoryId])
REFERENCES [dbo].[Categories] ([CategoryId])
GO
ALTER TABLE [dbo].[Products] CHECK CONSTRAINT [FK_Items_Category]
GO
ALTER TABLE [dbo].[Products]  WITH CHECK ADD  CONSTRAINT [FK_Items_ItemUnit] FOREIGN KEY([ProductUnitId])
REFERENCES [dbo].[ProductUnit] ([ProductUnitId])
GO
ALTER TABLE [dbo].[Products] CHECK CONSTRAINT [FK_Items_ItemUnit]
GO
ALTER TABLE [dbo].[Products]  WITH CHECK ADD  CONSTRAINT [FK_Items_VatRate] FOREIGN KEY([VatRateId])
REFERENCES [dbo].[VatRate] ([VatRateId])
GO
ALTER TABLE [dbo].[Products] CHECK CONSTRAINT [FK_Items_VatRate]
GO
ALTER TABLE [dbo].[Products]  WITH CHECK ADD  CONSTRAINT [FK_Items_VatRate1] FOREIGN KEY([TakeAwayVatRateId])
REFERENCES [dbo].[VatRate] ([VatRateId])
GO
ALTER TABLE [dbo].[Products] CHECK CONSTRAINT [FK_Items_VatRate1]
GO
ALTER TABLE [dbo].[Products]  WITH CHECK ADD  CONSTRAINT [FK_Products_WeightUnit] FOREIGN KEY([WeightUnitId])
REFERENCES [dbo].[ProductUnit] ([ProductUnitId])
GO
ALTER TABLE [dbo].[Products] CHECK CONSTRAINT [FK_Products_WeightUnit]
GO
ALTER TABLE [dbo].[ProductSoldDetails]  WITH CHECK ADD  CONSTRAINT [FK_ItemSoldDetails_Items] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[ProductSoldDetails] CHECK CONSTRAINT [FK_ItemSoldDetails_Items]
GO
ALTER TABLE [dbo].[ProductSoldDetails]  WITH CHECK ADD  CONSTRAINT [FK_ItemSoldDetails_Orders] FOREIGN KEY([LastSoldOrderId])
REFERENCES [dbo].[Orders] ([OrderId])
GO
ALTER TABLE [dbo].[ProductSoldDetails] CHECK CONSTRAINT [FK_ItemSoldDetails_Orders]
GO
ALTER TABLE [dbo].[ProductStock]  WITH CHECK ADD  CONSTRAINT [FK_ItemStock_Items] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[ProductStock] CHECK CONSTRAINT [FK_ItemStock_Items]
GO
ALTER TABLE [dbo].[ProductSuppliers]  WITH CHECK ADD  CONSTRAINT [FK_ItemSuppliers_Items] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[ProductSuppliers] CHECK CONSTRAINT [FK_ItemSuppliers_Items]
GO
ALTER TABLE [dbo].[ProductSuppliers]  WITH CHECK ADD  CONSTRAINT [FK_ItemSuppliers_suppliers] FOREIGN KEY([SupplierId])
REFERENCES [dbo].[Suppliers] ([SupplierId])
GO
ALTER TABLE [dbo].[ProductSuppliers] CHECK CONSTRAINT [FK_ItemSuppliers_suppliers]
GO
ALTER TABLE [dbo].[ProductVariants]  WITH CHECK ADD  CONSTRAINT [FK_ItemVariants_VariantGroups] FOREIGN KEY([VariantGroupId])
REFERENCES [dbo].[VariantGroups] ([VariantGroupId])
GO
ALTER TABLE [dbo].[ProductVariants] CHECK CONSTRAINT [FK_ItemVariants_VariantGroups]
GO
ALTER TABLE [dbo].[ProductVariants]  WITH CHECK ADD  CONSTRAINT [FK_product_variants_product_variants] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[ProductVariants] CHECK CONSTRAINT [FK_product_variants_product_variants]
GO
ALTER TABLE [dbo].[ProductVariants]  WITH CHECK ADD  CONSTRAINT [FK_product_variants_variant_group_values] FOREIGN KEY([VariantValueId])
REFERENCES [dbo].[VariantGroupValues] ([VariantValueId])
GO
ALTER TABLE [dbo].[ProductVariants] CHECK CONSTRAINT [FK_product_variants_variant_group_values]
GO
ALTER TABLE [dbo].[SupplierContactPersons]  WITH CHECK ADD  CONSTRAINT [FK_supplier_contact_person_suppliers] FOREIGN KEY([SupplierId])
REFERENCES [dbo].[Suppliers] ([SupplierId])
GO
ALTER TABLE [dbo].[SupplierContactPersons] CHECK CONSTRAINT [FK_supplier_contact_person_suppliers]
GO
ALTER TABLE [dbo].[TeamViewerSupportRequests]  WITH CHECK ADD  CONSTRAINT [FK_TeamViewerSupportRequests_PosDetails] FOREIGN KEY([PosId])
REFERENCES [dbo].[PosDetails] ([PosId])
GO
ALTER TABLE [dbo].[TeamViewerSupportRequests] CHECK CONSTRAINT [FK_TeamViewerSupportRequests_PosDetails]
GO
ALTER TABLE [dbo].[TeamViewerSupportRequests]  WITH CHECK ADD  CONSTRAINT [FK_TeamViewerSupportRequests_Users] FOREIGN KEY([UserId])
REFERENCES [dbo].[Users] ([UserId])
GO
ALTER TABLE [dbo].[TeamViewerSupportRequests] CHECK CONSTRAINT [FK_TeamViewerSupportRequests_Users]
GO
ALTER TABLE [dbo].[TempTileProducts]  WITH CHECK ADD  CONSTRAINT [FK_TempTileItems_Items] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[TempTileProducts] CHECK CONSTRAINT [FK_TempTileItems_Items]
GO
ALTER TABLE [dbo].[TempTileProducts]  WITH CHECK ADD  CONSTRAINT [FK_TempTileItems_Tiles] FOREIGN KEY([TileId])
REFERENCES [dbo].[TempTiles] ([TileId])
GO
ALTER TABLE [dbo].[TempTileProducts] CHECK CONSTRAINT [FK_TempTileItems_Tiles]
GO
ALTER TABLE [dbo].[TempTiles]  WITH CHECK ADD  CONSTRAINT [FK_TempTiles_Folders] FOREIGN KEY([FolderId])
REFERENCES [dbo].[TempFolders] ([FolderId])
GO
ALTER TABLE [dbo].[TempTiles] CHECK CONSTRAINT [FK_TempTiles_Folders]
GO
ALTER TABLE [dbo].[TileProducts]  WITH CHECK ADD  CONSTRAINT [FK_TileItems_Items] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[TileProducts] CHECK CONSTRAINT [FK_TileItems_Items]
GO
ALTER TABLE [dbo].[TileProducts]  WITH CHECK ADD  CONSTRAINT [FK_TileItems_Tiles] FOREIGN KEY([TileId])
REFERENCES [dbo].[Tiles] ([TileId])
GO
ALTER TABLE [dbo].[TileProducts] CHECK CONSTRAINT [FK_TileItems_Tiles]
GO
ALTER TABLE [dbo].[Tiles]  WITH CHECK ADD  CONSTRAINT [FK_Tiles_Folders] FOREIGN KEY([FolderId])
REFERENCES [dbo].[Folders] ([FolderId])
GO
ALTER TABLE [dbo].[Tiles] CHECK CONSTRAINT [FK_Tiles_Folders]
GO
ALTER TABLE [dbo].[Users]  WITH CHECK ADD  CONSTRAINT [FK_Users_DepartmentDetails] FOREIGN KEY([DepartmentId])
REFERENCES [dbo].[DepartmentDetails] ([DepartmentId])
GO
ALTER TABLE [dbo].[Users] CHECK CONSTRAINT [FK_Users_DepartmentDetails]
GO
ALTER TABLE [dbo].[Users]  WITH CHECK ADD  CONSTRAINT [FK_Users_UserGroups] FOREIGN KEY([UserGroupId])
REFERENCES [dbo].[UserGroups] ([UserGroupId])
GO
ALTER TABLE [dbo].[Users] CHECK CONSTRAINT [FK_Users_UserGroups]
GO
ALTER TABLE [dbo].[VariantGroupValues]  WITH CHECK ADD  CONSTRAINT [FK_Variants_VariantGroups] FOREIGN KEY([VariantGroupId])
REFERENCES [dbo].[VariantGroups] ([VariantGroupId])
GO
ALTER TABLE [dbo].[VariantGroupValues] CHECK CONSTRAINT [FK_Variants_VariantGroups]
GO
/****** Object:  StoredProcedure [dbo].[sp_CopyRoomsTablesData]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

--sp_CopyRoomsTablesData 0
CREATE PROCEDURE [dbo].[sp_CopyRoomsTablesData] @IsSuccess INT OUTPUT
AS
BEGIN
	BEGIN TRANSACTION;

	BEGIN TRY
		SET NOCOUNT ON;

		--if (select count(1) from ParkedOrders) = 0
		BEGIN

		-- :::: FOR TABLES - Start :::: 
		SELECT *
			INTO #TmpTable
			FROM TempTables
			--WHERE IsDeleted = 0 and IsActive = 1

			DECLARE @RowNumTable INT
				,@TableId NCHAR(5)
				--,@Name NCHAR(25)

			SELECT @TableId = MAX(TableId)
			FROM #TmpTable --start with the highest ID

			SELECT @RowNumTable = Count(*)
			FROM #TmpTable --get total number of records

			WHILE @RowNumTable > 0 --loop until no more records
			BEGIN
				--SELECT @Name = TableNumber
				--FROM #TmpTable
				--WHERE TableId = @TableId --get other info from that row

				--PRINT cast(@RowNumTable AS CHAR(12)) + ' ' + @TableId + ' ' + @Name --do whatever

				IF EXISTS (
						SELECT 1
						FROM [Tables]
						WHERE TableId = @TableId
						)
				BEGIN
					UPDATE t1
					SET t1.TableId = t2.TableId
						,t1.TableNumber = t2.TableNumber
						,t1.RoomId = t2.RoomId
						,t1.IsActive = t2.IsActive
						,t1.IsDeleted = t2.IsDeleted
					FROM [Tables] t1
						,#TmpTable t2
					WHERE t2.TableId = t1.TableId
				END
				ELSE
				BEGIN
					INSERT INTO [Tables]
					SELECT *
					FROM #TmpTable
					WHERE TableId = @TableId;
				END

				SELECT TOP 1 @TableId = TableId
				FROM #TmpTable
				WHERE TableId < @TableId
				ORDER BY TableId DESC --get the next one

				SET @RowNumTable = @RowNumTable - 1 --decrease count
			END

			UPDATE tb
			SET tb.IsDeleted = 1
			FROM [tables] AS tb
			LEFT JOIN #TmpTable AS ttb ON tb.TableId = ttb.TableId
			WHERE ttb.TableId IS NULL;

			
			DELETE
			FROM [Tables]
			WHERE [Tables].IsDeleted = 1
				AND NOT EXISTS (
					SELECT 1
					FROM ParkedOrders po
					WHERE po.TableId = [Tables].TableId
					UNION ALL
					SELECT 1
					FROM ServerParkedOrders po
					WHERE po.TableId = [Tables].TableId
					);
		-- :::: FOR TABLES - FINISH :::: 



		-- :::: FOR ROOMS - Start :::: 
			SELECT *
			INTO #TmpRoom
			FROM TempRooms
			--WHERE IsDeleted = 0 and IsActive = 1

			DECLARE @RowNum INT
				,@RoomId NCHAR(5)
				--,@Name1 NCHAR(25)

			SELECT @RoomId = MAX(RoomId)
			FROM #TmpRoom --start with the highest ID

			SELECT @RowNum = Count(*)
			FROM #TmpRoom --get total number of records

			WHILE @RowNum > 0 --loop until no more records
			BEGIN
				--SELECT @Name1 = roomname
				--FROM #TmpRoom
				--WHERE RoomId = @RoomId --get other info from that row

				--PRINT cast(@RowNum AS CHAR(12)) + ' ' + @RoomId + ' ' + @Name1 --do whatever

				IF EXISTS (
						SELECT 1
						FROM Rooms
						WHERE RoomId = @RoomId
						)
				BEGIN
					UPDATE t1
					SET t1.RoomId = t2.RoomId
						,t1.RoomName = t2.RoomName
						,t1.SortOrder = t2.SortOrder
						,t1.IsActive = t2.IsActive
						,t1.IsDeleted = t2.IsDeleted
					FROM Rooms t1
						,#TmpRoom t2
					WHERE t2.RoomId = t1.RoomId
				END
				ELSE
				BEGIN
					INSERT INTO Rooms
					SELECT *
					FROM #TmpRoom
					WHERE RoomId = @RoomId;
				END

				SELECT TOP 1 @RoomId = RoomId
				FROM #TmpRoom
				WHERE RoomId < @RoomId
				ORDER BY RoomId DESC --get the next one

				SET @RowNum = @RowNum - 1 --decrease count
			END

			UPDATE rm
			SET rm.IsDeleted = 1
			FROM Rooms AS rm
			LEFT JOIN #TmpRoom AS trm ON rm.RoomId = trm.RoomId
			WHERE trm.RoomId IS NULL;
	
			DELETE
			FROM Rooms
			WHERE Rooms.IsDeleted = 1
				AND NOT EXISTS (
					SELECT 1
					FROM ParkedOrders po
					INNER JOIN [Tables] tb
					INNER JOIN rooms rm ON tb.RoomId = rm.RoomId ON po.TableId = tb.TableId WHERE tb.RoomId = Rooms.RoomId
					UNION ALL
					SELECT 1
					FROM ServerParkedOrders po
					INNER JOIN [Tables] tb
					INNER JOIN rooms rm ON tb.RoomId = rm.RoomId ON po.TableId = tb.TableId WHERE tb.RoomId = Rooms.RoomId
					);

			-- :::: FOR ROOMS - FINISH :::: 

			--	  IF EXISTS (SELECT 1 FROM dbo.table WHERE PK = @PK)
			--BEGIN
			--  UPDATE ...
			--END
			--ELSE
			--BEGIN
			--  INSERT ...
			--END
			-- need to get id of tables/rooms which has parked order
			-- except those tables we can to delete tables/rooms
			--INSERT INTO Rooms SELECT * FROM TempRooms where IsDeleted = 0;
			--INSERT INTO [Tables] SELECT * FROM TempTables where IsDeleted = 0;
			DROP TABLE #TmpRoom
			DROP TABLE #TmpTable

			COMMIT TRANSACTION;

			SET @IsSuccess = 1
		END
			--ELSE
			--BEGIN
			--SET @IsSuccess = -1
			--END
			--PRINT convert(varchar(10),@IsSuccess);
	END TRY

	BEGIN CATCH
		ROLLBACK TRANSACTION;

		SET @IsSuccess = 0
	END CATCH;

	SELECT @IsSuccess
END




GO
/****** Object:  StoredProcedure [dbo].[sp_CopyTilesData]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[sp_CopyTilesData] @IsSuccess int OUTPUT

AS
BEGIN
BEGIN TRANSACTION;

BEGIN TRY

	SET Nocount ON;
	--select * from Tiles;

	 Delete from TileProducts;
	 Delete from Tiles;
	 Delete from Folders;
	 Delete from Groups;

	INSERT INTO Groups SELECT * FROM TempGroups;
	INSERT INTO Folders SELECT * FROM TempFolders;
	INSERT INTO Tiles SELECT * FROM TempTiles;
	INSERT INTO TileProducts SELECT * FROM TempTileProducts;

    COMMIT TRANSACTION;
	SET @IsSuccess = 1
	--PRINT convert(varchar(10),@IsSuccess);
	
END TRY

BEGIN CATCH

    ROLLBACK TRANSACTION;
	SET @IsSuccess = 0
END CATCH;
Select @IsSuccess
END

GO
/****** Object:  StoredProcedure [dbo].[sp_GetCategoriesTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- sp_GetCategoriesTurnover '2016-01-31 13:18:00','2018-01-31 13:18:00',1
-- =============================================
-- Change in sp_GetCategoriesTurnover
-- =============================================
CREATE PROCEDURE [dbo].[sp_GetCategoriesTurnover] @p_Start datetime,
@p_End datetime,
@pos_id int
AS
BEGIN
  SET NOCOUNT ON;
  SELECT
    t1.CategoryName,
    t1.CategoryId,
	t3.VatRateMultiplier,cast((t3.VatRateMultiplier*100) as decimal(10,2)) - 100 as VatRatePercent ,
    ROUND(SUM((t3.TotalProductPriceExclVat)), 2) AS TurnoverExclVat,	-- Turnover (excl VAT)
    ROUND(SUM(t3.TotalProductPriceInclVat), 2) AS [TurnoverInclVat],		-- Turnover (incl VAT)
    ROUND(SUM(t3.TotalVatAmount), 2) AS TurnoverVat,
    (SELECT
      ROUND(SUM(RoundOff), 2)
    FROM Orders
    WHERE OrderDateTime BETWEEN @p_Start
    AND @p_End

    AND PosId = @pos_id)
    AS [TotalRoundOff],		-- Turnover (incl VAT)
    COUNT(t3.OrderId) AS OrderCount,
	SUM(t3.Quantity) AS TotalProducts														-- Amount of orders
  FROM Categories t1
  INNER JOIN Products t2
    ON (t1.CategoryId = t2.CategoryId)
  INNER JOIN OrderDetails t3
    ON (t2.ProductId = t3.ProductID)
  INNER JOIN Orders t4
    ON (t3.OrderID = t4.OrderId)
  WHERE t4.OrderDateTime BETWEEN @p_Start
  AND @p_End
  AND t4.PosId = @pos_id
  AND t3.IsCombo = 0
  GROUP BY t3.VatRateMultiplier,
  t1.CategoryName,
           t1.CategoryId

END


GO
/****** Object:  StoredProcedure [dbo].[sp_GetGiftCardsAndCreditNotes]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Ver: 1.0.12
-- =============================================
-- [dbo].[sp_GetGiftCardsAndCreditNotes] '2015-11-30 00:00:00', '2016-11-30 23:59:00',1
CREATE PROCEDURE [dbo].[sp_GetGiftCardsAndCreditNotes] @p_Start datetime,
@p_End datetime,
@pos_id int
AS
BEGIN
  SET NOCOUNT ON;




  SELECT
  IssuedGiftCards=(SELECT 
    IsNULL(SUM(gc.OriginalAmount),0) AS IssuedGiftCards	
    FROM GiftCards gc
	inner join Orders ord
	on gc.OrderId = ord.OrderId
    WHERE ord.OrderDateTime BETWEEN @p_Start
    AND @p_End
	AND ord.PosId = @pos_id),

				  IssuedGiftCardsCount=(SELECT 
   count(gc.GiftCardId) as IssuedGiftCardsCount
    FROM GiftCards gc
	inner join Orders ord
	on gc.OrderId = ord.OrderId
    WHERE ord.OrderDateTime BETWEEN @p_Start
    AND @p_End
	AND ord.PosId = @pos_id),

	  IssuedCreditnotes=(SELECT 
    IsNull(SUM(cn.OriginalAmount),0) AS IssuedCreditnotes	
    FROM CreditNotes cn
	inner join Orders ord
	on cn.OrderId = ord.OrderId
    WHERE ord.OrderDateTime BETWEEN @p_Start
    AND @p_End
	AND ord.PosId = @pos_id),

	 IssuedCreditnotesCount=(SELECT 
   count(cn.CreditNoteId) as IssuedCreditnotesCount
    FROM CreditNotes cn
	inner join Orders ord
	on cn.OrderId = ord.OrderId
    WHERE ord.OrderDateTime BETWEEN @p_Start
    AND @p_End
	AND ord.PosId = @pos_id)

	--	  UsedGiftCards=(SELECT
 --   IsNull(SUM(pa.Amount),0) AS UsedGiftCards	
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'giftvoucher'
	--AND ord.PosId = @pos_id),

	--		  UsedGiftCardsCount=(SELECT count(pa.paymentid) as UsedGiftCardsCount
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'giftvoucher'
	--AND ord.PosId = @pos_id),

	--	  UsedCreditnotes=(SELECT
 --   IsNull(SUM(pa.Amount),0) AS UsedCreditnotes	
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'creditnote'
	--AND ord.PosId = @pos_id),

	--		  UsedCreditnotesCount=(SELECT count(pa.paymentid) as UsedCreditnotesCount
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'creditnote'
	--AND ord.PosId = @pos_id),
 -- --  AND PosId = @pos_id)
 -- --  AS [TotalRoundOff],		-- Turnover (incl VAT)
 -- --  COUNT(t3.OrderId) AS OrderCount														-- Amount of orders
 -- --FROM Categories t1
 -- --INNER JOIN Products t2
 -- --  ON (t1.CategoryId = t2.CategoryId)
 -- --INNER JOIN OrderDetails t3
 -- --  ON (t2.ProductId = t3.ProductID)
 -- --INNER JOIN Orders t4
 -- --  ON (t3.OrderID = t4.OrderId)
 -- --WHERE t4.OrderDateTime BETWEEN @p_Start
 -- --AND @p_End
 -- --AND t4.PosId = @pos_id
 -- --GROUP BY t1.CategoryName,
 -- --         t1.CategoryId
 -- CashPayment=(SELECT
 --   IsNull(SUM(pa.Amount),0) AS CashPayment	
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'cash'
	--AND ord.PosId = @pos_id),

	--  CashPaymentCount=(SELECT count(pa.paymentid) as CashPaymentCount
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'cash'
	--AND ord.PosId = @pos_id),

	--TerminalPayment=(SELECT
 --   IsNull(SUM(pa.Amount),0) AS TerminalPayment	
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'card'
	--AND ord.PosId = @pos_id),

	--	TerminalPaymentCount=(SELECT count(pa.paymentid) as TerminalPaymentCount
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'card'
	--AND ord.PosId = @pos_id)

END

GO
/****** Object:  StoredProcedure [dbo].[sp_GetHoldOrders]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[sp_GetHoldOrders] @pos_id int
AS
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  SET NOCOUNT ON;

SELECT DISTINCT ho.OrderReference, ho.CustomerId,c.CustomerName, ho.CreatedBy,u.UserName, ho.CreatedDateTime,ho.HoldOrderUuid, SUM(ho.SubTotal) AS OrderTotal FROM dbo.HoldOrders ho
LEFT JOIN dbo.Customers c ON ho.CustomerId = c.CustomerId
JOIN dbo.Users u ON ho.CreatedBy = u.UserId
WHERE ho.PosId = @pos_id AND ho.ComboParentProductId is null
GROUP BY ho.OrderReference, ho.CustomerId,c.CustomerName, ho.CreatedBy,u.UserName, ho.CreatedDateTime,ho.HoldOrderUuid
ORDER BY ho.CreatedDateTime DESC
END




GO
/****** Object:  StoredProcedure [dbo].[sp_GetJournalReport]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:  	<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
-- [dbo].[sp_GetJournalReport] '2016-02-23', '2016-11-13',1
CREATE PROCEDURE [dbo].[sp_GetJournalReport] @p_Start datetime,
@p_End datetime,
@pos_id int

AS
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  -- interfering with SELECT statements.
  SET NOCOUNT ON;

  SELECT
    t1.OrderId,
    t2.Quantity,
    OrderDateTime,
    t2.ProductName,
    --t2.Price-t2.ItemDiscount as aPrice,
    CAST((t2.ProductPriceInclVat + t2.ProductDiscount) as decimal(10,2)) AS RegularPrice,--aPrice,
	t2.ProductDiscount AS ProductDiscount,
	t2.ProductPriceInclVat AS PriceInclVat,
	t2.ProductPriceExclVat AS PriceExclVat,
	t2.TotalProductPriceInclVat AS TotalPriceInclVat,
	t2.TotalProductPriceExclVat AS TotalPriceExclVat,
    t2.TotalVatAmount AS TotalVat,
   -- t2.Quantity * (t2.ProductPriceInclVat - t2.ProductDiscount) - (t2.Quantity * (t2.ProductPriceInclVat - t2.ProductDiscount) / t2.VatRateMultiplier) AS vat,
    t4.UserName,
    t3.ProductNumber,
   -- t2.Quantity * (t2.ProductPriceInclVat - t2.ProductDiscount) AS PriceInclVat,
   -- (t2.Quantity * (t2.ProductPriceInclVat - t2.ProductDiscount) - (t2.Quantity * (t2.ProductPriceInclVat - t2.ProductDiscount) - (t2.Quantity * (t2.ProductPriceInclVat - t2.ProductDiscount) / t2.VatRateMultiplier))) AS PriceExclVat,
    ((t2.VatRateMultiplier * 100) - 100) AS VatRatePercent,
    t2.TotalProductDiscount AS TotalDiscount,
    ROW_NUMBER() OVER (PARTITION BY t1.orderid ORDER BY t1.orderid) AS productcountorderwiseindex,
	1 as AscendingOrderFlag
  FROM Orders t1
  INNER JOIN OrderDetails t2
    ON (t1.OrderId = t2.OrderID)
  INNER JOIN Products t3
    ON (t2.ProductID = t3.ProductId) --inner join
  INNER JOIN Users t4
    ON t1.UserId = t4.UserId
  WHERE t1.PosId = @pos_id --and lower(t3.ProductNumber) != 'giftcard'
  AND t1.OrderDateTime BETWEEN @p_Start AND @p_End
  

-- for generated giftcards
  UNION
  select t1.OrderId, 1, t1.CreatedDateTime, 'GAVEKORT'
  , t1.OriginalAmount as RegularPrice
    , NULL as ProductDiscount
	  , NULL as PriceInclVat
	    , NULL as PriceExclVat
		  , NULL as TotalPriceInclVat
		    , NULL as TotalPriceExclVat
			  , NULL as TotalVat
			    , t2.UserName as UserName
				, NULL as ProductNumber
				, NULL as VatRatePercent
				, NULL as TotalDiscount
				, ROW_NUMBER() OVER (PARTITION BY t1.orderid ORDER BY t1.orderid) AS productcountorderwiseindex
				,2 as AscendingOrderFlag
    from
  GiftCards t1
    INNER JOIN Users t2
    ON t1.CreatedBy = t2.UserId
  left join Orders t3 on
  t1.OrderId = t3.OrderId
    WHERE t3.PosId = @pos_id --and lower(t3.ProductNumber) != 'giftcard'
  AND t1.CreatedDateTime BETWEEN @p_Start AND @p_End
  
  -- for generated credit notes
  UNION
  select t1.OrderId, 1, t1.CreatedDateTime, 'TILGODELAPP'
  , t1.OriginalAmount as RegularPrice
    , NULL as ProductDiscount
	  , NULL as PriceInclVat
	    , NULL as PriceExclVat
		  , NULL as TotalPriceInclVat
		    , NULL as TotalPriceExclVat
			  , NULL as TotalVat
			    , t2.UserName as UserName
				, NULL as ProductNumber
				, NULL as VatRatePercent
				, NULL as TotalDiscount
				, ROW_NUMBER() OVER (PARTITION BY t1.orderid ORDER BY t1.orderid) AS productcountorderwiseindex
				,2 as AscendingOrderFlag
    from
  CreditNotes t1
    INNER JOIN Users t2
    ON t1.CreatedBy = t2.UserId
  left join Orders t3 on
  t1.OrderId = t3.OrderId
    WHERE t3.PosId = @pos_id --and lower(t3.ProductNumber) != 'giftcard'
  AND t1.CreatedDateTime BETWEEN @p_Start AND @p_End
  ORDER BY OrderId, AscendingOrderFlag, productcountorderwiseindex

END

GO
/****** Object:  StoredProcedure [dbo].[sp_GetNetVatTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Change in sp_GetNetVatTurnover '2016-01-31 13:18:00','2018-01-31 13:18:00',5
-- =============================================
CREATE PROCEDURE [dbo].[sp_GetNetVatTurnover] @p_Start datetime,
@p_End datetime,
@pos_id int
AS
BEGIN
  SET NOCOUNT ON;
  Select cast((t1.VatRateMultiplier*100) as decimal(10,2)) - 100 as VatRatePercent , CAST((t1.VatRateMultiplier*100) - 100 as varchar) + '% MVA' as VatRateTitle,
 ROUND(SUM((t1.TotalProductPriceExclVat)), 2) AS TurnoverExclVat,	-- Turnover (excl VAT)
 ROUND(SUM(t1.TotalProductPriceInclVat), 2) AS [TurnoverInclVat],		-- Turnover (incl VAT)
 ROUND(SUM(t1.TotalVatAmount), 2) AS TurnoverVat,
 -SUM(t1.Quantity) AS TotalProducts
FROM OrderDetails t1
INNER JOIN Orders t2
ON (t1.OrderId = t2.OrderId)
  WHERE t2.OrderDateTime BETWEEN @p_Start
  AND @p_End
  AND t2.PosId = @pos_id AND t1.IsCombo = 0
  GROUP BY t1.VatRateMultiplier
  Order By t1.VatRateMultiplier

END
GO
/****** Object:  StoredProcedure [dbo].[sp_GetNextOrderNoSequenceValue]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dipesh>
-- Create date: <31 December 2015>
-- Description:	<To generate sequence for Order No.>
-- =============================================
CREATE PROCEDURE [dbo].[sp_GetNextOrderNoSequenceValue] 
AS 
BEGIN
    SELECT NEXT VALUE FOR dbo.SequenceOrderNo;
END



GO
/****** Object:  StoredProcedure [dbo].[sp_GetPaymentTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Ver: 1.0.12
-- =============================================
-- [dbo].[sp_GetPaymentTurnover] '2015-11-30 00:00:00', '2016-11-30 23:59:00',1
CREATE PROCEDURE [dbo].[sp_GetPaymentTurnover] @p_Start datetime,
@p_End datetime,
@pos_id int
AS
BEGIN
  SET NOCOUNT ON;
  SELECT pa.PaymentTypeId, pt.PaymentType,
    IsNull(SUM(pa.Amount),0) As Amount, 
	COUNT(pa.paymentid) as NumberOfTransactions
    FROM Payments pa
	inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	inner join Orders ord
	on pa.OrderId = ord.OrderId
    WHERE ord.OrderDateTime BETWEEN @p_Start
    AND @p_End 
	AND ord.PosId = @pos_id
	  GROUP BY pa.PaymentTypeId, pt.PaymentType

 -- SELECT

	--	  UsedGiftCards=(SELECT
 --   IsNull(SUM(pa.Amount),0) AS UsedGiftCards	
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'giftvoucher'
	--AND ord.PosId = @pos_id),

	--		  UsedGiftCardsCount=(SELECT count(pa.paymentid) as UsedGiftCardsCount
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'giftvoucher'
	--AND ord.PosId = @pos_id),

	--	  UsedCreditnotes=(SELECT
 --   IsNull(SUM(pa.Amount),0) AS UsedCreditnotes	
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'creditnote'
	--AND ord.PosId = @pos_id),

	--		  UsedCreditnotesCount=(SELECT count(pa.paymentid) as UsedCreditnotesCount
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'creditnote'
	--AND ord.PosId = @pos_id),


 
 -- CashPayment=(SELECT
 --   IsNull(SUM(pa.Amount),0) AS CashPayment	
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'cash'
	--AND ord.PosId = @pos_id),

	--  CashPaymentCount=(SELECT count(pa.paymentid) as CashPaymentCount
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'cash'
	--AND ord.PosId = @pos_id),

	--TerminalPayment=(SELECT
 --   IsNull(SUM(pa.Amount),0) AS TerminalPayment	
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'card'
	--AND ord.PosId = @pos_id),

	--	TerminalPaymentCount=(SELECT count(pa.paymentid) as TerminalPaymentCount
 --   FROM Payments pa
	--inner join PaymentTypes pt on pa.PaymentTypeId = pt.PaymentTypeId
	--inner join Orders ord
	--on pa.OrderId = ord.OrderId
 --   WHERE ord.OrderDateTime BETWEEN @p_Start
 --   AND @p_End 
	--AND pt.PaymentType = 'card'
	--AND ord.PosId = @pos_id)

END

GO
/****** Object:  StoredProcedure [dbo].[sp_GetPreviousWeeksTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:    <Dipesh>
-- Create date: <3 December 2015>
-- Description:	<to calculate last 10 weeks turnover for current department>
-- =============================================
-- [dbo].[sp_GetPreviousWeeksTurnover] 
CREATE PROCEDURE [dbo].[sp_GetPreviousWeeksTurnover] 

AS
BEGIN
  SET NOCOUNT ON;

  DECLARE @current_date datetime

  SET @current_date = GETDATE()--GETDATE() -- this is commented for testing --'2018-01-31 00:00:00.000'
  --print @p_Start
  --print @p_End

  DECLARE @temp_table1 TABLE (
    id int IDENTITY (1, 1) PRIMARY KEY,
    currentyear varchar(4),
    weeknumber varchar(2)
  )
  DECLARE @temp_table2 TABLE (
    id int IDENTITY (1, 1) PRIMARY KEY,
    currentyear varchar(4),
    weeknumber varchar(2),
    startdate datetime,
    enddate datetime
  )
  DECLARE @temp_table3 TABLE (
    id int IDENTITY (1, 1) PRIMARY KEY,
    currentyear varchar(4),
    weeknumber varchar(2),
    startdate datetime,
    enddate datetime,
    turnoverexclvat money
  )

  INSERT INTO @temp_table1

    SELECT
      YEAR(DATEADD(WEEK, X.Y, BaseDate)) AS CurrentYear,
      DATEPART(ISO_WEEK, DATEADD(WEEK, X.Y, BaseDate)) AS WeekNumber
    FROM (SELECT
      CAST(@current_date AS date) AS BaseDate) D
    CROSS JOIN (
    VALUES (0), (-1), (-2), (-3), (-4), (-5), (-6), (-7), (-8), (-9)
    ) AS X (Y);

  INSERT INTO @temp_table1
    SELECT
      currentyear - 1,
      weeknumber
    FROM @temp_table1


  DECLARE @totalRecords int
  DECLARE @I int
  SELECT
    @I = 1
  SELECT
    @totalRecords = COUNT(*)
  FROM @temp_table1
  WHILE (@I <= @totalRecords)
  BEGIN

    SET DATEFIRST 1
    DECLARE @wk int
    DECLARE @yr int

    DECLARE @sdate datetime
    DECLARE @edate datetime


    SELECT
      @wk = weeknumber,
      @yr = currentyear
    FROM @temp_table1
    WHERE id = @I


    INSERT INTO @temp_table2
      SELECT
        @yr AS [year],
        @wk AS weeknumber,
        DATEADD(WEEK, @wk, DATEADD(YEAR, @yr - 1900, 0)) - 4 -
        DATEPART(dw, DATEADD(WEEK, @wk, DATEADD(YEAR, @yr - 1900, 0)) - 4) + 1 AS startdate,
        DATEADD(WEEK, @wk, DATEADD(YEAR, @yr - 1900, 0)) - 4 -
        DATEPART(dw, DATEADD(WEEK, @wk, DATEADD(YEAR, @yr - 1900, 0)) - 4) + 7 AS enddate

    --PRINT @I
    SELECT
      @I = @I + 1
  END


  DECLARE @totalRecords_1 int
  DECLARE @I_1 int
  SELECT
    @I_1 = 1
  SELECT
    @totalRecords_1 = COUNT(*)
  FROM @temp_table2


  WHILE (@I_1 <= @totalRecords_1)
  BEGIN

    DECLARE @pwk int
    DECLARE @pyr int
    DECLARE @p_Start datetime
    DECLARE @p_End datetime
    DECLARE @turnover money

    SELECT
      @pwk = weeknumber,
      @pyr = currentyear,
      @p_Start = startdate,
      @p_End = enddate
    FROM @temp_table2
    WHERE id = @I_1

    SET @turnover = (SELECT
      ROUND(SUM((t3.TotalProductPriceExclVat)), 2) AS TurnoverExclVat	-- Turnover (excl VAT)										
    FROM Categories t1
    INNER JOIN Products t2
      ON (t1.CategoryId = t2.CategoryId)
    INNER JOIN OrderDetails t3
      ON (t2.ProductId = t3.ProductID)
    INNER JOIN Orders t4
      ON (t3.OrderID = t4.OrderId)
    WHERE t4.OrderDateTime >= @p_Start AND lower(t2.ProductNumber) != 'giftcard'
    AND t4.OrderDateTime < DATEADD(DAY, 1, @p_End)	AND t3.IsCombo = 0)


    INSERT INTO @temp_table3
      SELECT
        @pyr AS [year],
        @pwk AS weeknumber,
        @p_Start AS startdate,
        @p_End AS enddate,
        ISNULL(@turnover, 0)

    SELECT
      @I_1 = @I_1 + 1

  END

  SELECT
    *
  FROM @temp_table3

END

GO
/****** Object:  StoredProcedure [dbo].[sp_GetReturnVatTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Change in sp_GetReturnVatTurnover '2016-01-31 13:18:00','2018-01-31 13:18:00',1
-- =============================================
CREATE PROCEDURE [dbo].[sp_GetReturnVatTurnover] @p_Start datetime,
@p_End datetime,
@pos_id int
AS
BEGIN
  SET NOCOUNT ON;
  Select cast((t1.VatRateMultiplier*100) as decimal(10,2)) - 100 as VatRatePercent , CAST((t1.VatRateMultiplier*100) - 100 as varchar) + '% MVA' as VatRateTitle,
 ROUND(SUM((t1.TotalProductPriceExclVat)), 2) AS TurnoverExclVat,	-- Turnover (excl VAT)
 ROUND(SUM(t1.TotalProductPriceInclVat), 2) AS [TurnoverInclVat],		-- Turnover (incl VAT)
 ROUND(SUM(t1.TotalVatAmount), 2) AS TurnoverVat,
 -SUM(t1.Quantity) AS TotalProducts
FROM OrderDetails t1
INNER JOIN Orders t2
ON (t1.OrderId = t2.OrderId)
  WHERE t2.OrderDateTime BETWEEN @p_Start
  AND @p_End
   AND t1.TotalProductPriceInclVat < 0
  AND t2.PosId = @pos_id AND t1.IsCombo = 0
  GROUP BY t1.VatRateMultiplier
  Order By t1.VatRateMultiplier

END
	


GO
/****** Object:  StoredProcedure [dbo].[sp_GetRooms]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[sp_GetRooms]
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	SET NOCOUNT ON;

--select TOP 8 * from ROOMS(NOLOCK)
--where (IsDeleted = 0 and IsActive = 1) or
--    EXISTS (
--					SELECT 1
--					FROM ParkedOrders po
--					INNER JOIN [Tables](NOLOCK) tb
--					INNER JOIN rooms rm ON tb.RoomId = rm.RoomId ON po.TableId = tb.TableId WHERE tb.RoomId = Rooms.RoomId and po.IsDeleted =0 and po.IsPaymentDone=0
--					UNION ALL
--					SELECT 1
--					FROM ServerParkedOrders po
--					INNER JOIN [Tables](NOLOCK) tb
--					INNER JOIN rooms rm ON tb.RoomId = rm.RoomId ON po.TableId = tb.TableId WHERE tb.RoomId = Rooms.RoomId and po.IsDeleted =0 and po.IsPaymentDone=0

--					) order by SortOrder,RoomName;
select TOP 8 * from ROOMS(NOLOCK)
where (IsDeleted = 0 and IsActive = 1) or
    EXISTS (
					SELECT 1
					FROM ParkedOrders po
					INNER JOIN [Tables] tb(NOLOCK) ON po.TableId = tb.TableId and tb.RoomId = Rooms.RoomId
					WHERE  po.IsDeleted =0 and po.IsPaymentDone=0
					UNION ALL
					SELECT 1
					FROM ServerParkedOrders po
					INNER JOIN [Tables](NOLOCK) tb ON po.TableId = tb.TableId and tb.RoomId = Rooms.RoomId 
					WHERE po.IsDeleted =0 and po.IsPaymentDone=0
			) order by SortOrder,RoomName;
					
END

GO
/****** Object:  StoredProcedure [dbo].[sp_GetTablesByRoom]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[sp_GetTablesByRoom] @room_id int
AS
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  SET NOCOUNT ON;


  DECLARE @TempParkedOrderTable TABLE (
    TableId int,
    ParkedOrderUuid uniqueidentifier,
    CustomerId int,
    CustomerName nvarchar(90),
    Total money
  )

  INSERT INTO @TempParkedOrderTable (TableId, ParkedOrderUuid, CustomerId, CustomerName, Total)

    SELECT
      trt.TableId,
      trt.ParkedOrderUuid,
      trt.CustomerId,
      trt.CustomerName,
      SUM(trt.SubTotal) AS Total
    FROM (
	
	SELECT
      po.TableId,
      po.RowNumberUuid,
      po.CustomerId,
      po.SubTotal,
      po.ParkedOrderUuid,
      --cu.CustomerName
	  '' AS CustomerName
    FROM dbo.ParkedOrders po 
	INNER JOIN [Tables] tb(NOLOCK) ON po.TableId = tb.TableId and tb.RoomId = @room_id
    --LEFT JOIN customers cu
    --  ON po.CustomerId = cu.CustomerId
    WHERE po.IsPaymentDone = 0 AND po.ComboParentProductId is null
    AND po.IsDeleted = 0 

    UNION
    SELECT
      spo.TableId,
      spo.RowNumberUuid,
      spo.CustomerId,
      spo.SubTotal,
      spo.ParkedOrderUuid,
      --cu.CustomerName
	  '' AS CustomerName
    FROM dbo.ServerParkedOrders spo
	INNER JOIN [Tables] tb(NOLOCK) ON spo.TableId = tb.TableId and tb.RoomId = @room_id
    --LEFT JOIN customers cu
    --  ON spo.CustomerId = cu.CustomerId
    WHERE spo.IsPaymentDone = 0 AND spo.ComboParentProductId is null
    AND spo.IsDeleted = 0
	
	) AS trt
    GROUP BY trt.TableId,
             trt.ParkedOrderUuid,
             trt.CustomerId,
             trt.CustomerName


  SELECT
    *
  FROM (
  
  SELECT TOP 50
    tb.TableId,
    tb.TableNumber,
    tb.RoomId,
    po.ParkedOrderUuid,
    po.Total AS TotalToPay,
    po.CustomerId,
    po.CustomerName,
    (
	
	SELECT
      MAX(UpdatedDateTime)
    FROM (SELECT
      po2.UpdatedDateTime
    FROM dbo.ParkedOrders po2
    WHERE po2.TableId = tb.tableId AND po2.IsDeleted =0 and po2.IsPaymentDone=0
    UNION ALL
    SELECT 
       po3.UpdatedDateTime
    FROM ServerParkedOrders po3
    WHERE po3.TableId = tb.tableid AND po3.IsDeleted =0 and po3.IsPaymentDone=0
	
	) AS LastModifiedTime
	
	)
    AS LastModifiedTime
	,
    ROW_NUMBER() OVER (PARTITION BY tb.TableId ORDER BY po.Total DESC) rn

  FROM [tables](NOLOCK) tb
  LEFT JOIN @TempParkedOrderTable po
    ON tb.TableId = po.TableId
  WHERE tb.RoomId = @room_id
  AND ((tb.IsActive = 1
  AND tb.IsDeleted = 0) OR (po.TableId is not NULL))
  GROUP BY tb.TableId,
           tb.TableNumber,
           tb.RoomId,
           po.ParkedOrderUuid,
           po.Total,
           po.CustomerId,
           po.CustomerName
  ORDER BY tb.TableNumber
  
  ) a
  WHERE rn = 1




END




GO
/****** Object:  StoredProcedure [dbo].[sp_GetUserTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Change in sp_GetUserTurnover
-- =============================================
CREATE PROCEDURE [dbo].[sp_GetUserTurnover] @p_Start datetime,
@p_End datetime,
@pos_id int
AS
BEGIN
  SET NOCOUNT ON;
  Select t2.UserId, t3.FirstName + ' ' + t3.LastName as Name,
 ROUND(SUM((t1.TotalProductPriceExclVat)), 2) AS TurnoverExclVat,	-- Turnover (excl VAT)
 ROUND(SUM(t1.TotalProductPriceInclVat), 2) AS [TurnoverInclVat],		-- Turnover (incl VAT)
 ROUND(SUM(t1.TotalVatAmount), 2) AS TurnoverVat
FROM OrderDetails t1
INNER JOIN Orders t2
ON (t1.OrderId = t2.OrderId)
INNER JOIN Users t3
ON (t2.UserId = t3.UserId)
  WHERE t2.OrderDateTime BETWEEN @p_Start
  AND @p_End
  AND t2.PosId = @pos_id AND t1.IsCombo = 0
  GROUP BY t2.UserId, t3.FirstName + ' ' + t3.LastName
  Order By t2.UserId

END
	

GO
/****** Object:  StoredProcedure [dbo].[sp_GetVatTurnover]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Change in sp_GetVatTurnover
-- =============================================
CREATE PROCEDURE [dbo].[sp_GetVatTurnover] @p_Start datetime,
@p_End datetime,
@pos_id int
AS
BEGIN
  SET NOCOUNT ON;
  Select cast((t1.VatRateMultiplier*100) as decimal(10,2)) - 100 as VatRatePercent , CAST((t1.VatRateMultiplier*100) - 100 as varchar) + '% MVA' as VatRateTitle,
 ROUND(SUM((t1.TotalProductPriceExclVat)), 2) AS TurnoverExclVat,	-- Turnover (excl VAT)
 ROUND(SUM(t1.TotalProductPriceInclVat), 2) AS [TurnoverInclVat],		-- Turnover (incl VAT)
 ROUND(SUM(t1.TotalVatAmount), 2) AS TurnoverVat
FROM OrderDetails t1
INNER JOIN Orders t2
ON (t1.OrderId = t2.OrderId)
  WHERE t2.OrderDateTime BETWEEN @p_Start
  AND @p_End
   AND t1.TotalProductPriceInclVat > 0
  AND t2.PosId = @pos_id AND t1.IsCombo = 0
  GROUP BY t1.VatRateMultiplier
  Order By t1.VatRateMultiplier

END
	

GO
/****** Object:  StoredProcedure [dbo].[sp_MoveTables]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[sp_MoveTables] @from_table_id int,
@to_table_id int,
@user_id int,
@pos_id int,
@IsSuccess int OUTPUT
AS
BEGIN

  DECLARE @i int;
  DECLARE @to_parked_order_uuid uniqueidentifier;
  DECLARE @from_parked_order_uuid uniqueidentifier;
  DECLARE @new_parked_order_uuid uniqueidentifier;
  DECLARE @to_customer_id int;
  DECLARE @from_customer_id int;
  DECLARE @customer_id int = NULL;
  DECLARE @current_datetime datetime = GetDate();
  DECLARE @previous_datetime datetime = DATEADD(DAY, -1, GETDATE());
  --DECLARE @tempCount int;

  --:::: Created Temporary table variable to save old data of parked orders (source and destination tables)
  DECLARE @TempExistingParkedOrderTable TABLE (
    [TableId] int,
    [LineNumber] [tinyint] NOT NULL,
    [ProductId] [int] NOT NULL,
    [ProductName] [nvarchar](150) NOT NULL,
    [Quantity] [decimal](10, 2) NOT NULL,
    [ProductPriceInclVat] [money] NOT NULL,
    [ProductPriceExclVat] [money] NOT NULL,
    [TotalProductPriceInclVat] [money] NOT NULL,
    [TotalProductPriceExclVat] [money] NOT NULL,
    [VatRateMultiplier] [float] NOT NULL,
    [VatRatePercent] [decimal](10, 2) NULL,
    [TotalVatAmount] [money] NOT NULL,
    [DiscountPercentage] [real] NULL,
    [ProductDiscount] [money] NULL,
    [TotalProductDiscount] [money] NULL,
    [PurchasePrice] [money] NULL,
    [SubTotal] [money] NOT NULL,
    [ParkedOrderUuid] [uniqueidentifier] NOT NULL,
    [CustomerId] [int] NULL,
    [PosId] [int] NOT NULL,
    [CreatedDateTime] [datetime] NOT NULL,
    [CreatedBy] [int] NOT NULL,
    [UpdatedDateTime] [datetime] NULL,
    [UpdatedBy] [int] NULL,
    [IsActive] [bit] NOT NULL,
    [IsDeleted] [bit] NOT NULL,
    [IsTakeAway] [bit] NOT NULL,
    [IsPriceChanged] [bit] NOT NULL,
    [FailSyncAttemptCount] [tinyint] NULL,
    [IsSyncSuccess] [bit] NOT NULL,
    [SyncAttemptDate] [datetime] NULL,
    [IsLocked] [bit] NOT NULL,
    [IsBonged] [bit] NOT NULL,
    [IsPaymentDone] [bit] NOT NULL,
    [NormalPriceInclVat] [money] NULL,
    [NormalPriceExclVat] [money] NULL,
    [TakeAwayPriceInclVat] [money] NULL,
    [TakeAwayPriceExclVat] [money] NULL,
    [RowNumberUuid] [uniqueidentifier] NOT NULL,
	[Comment] [nvarchar](max) NULL,
	[IsCombo] [bit]NOT NULL,
	[ComboParentProductId] [int] NULL,
	[CartIndexUuid] [uniqueidentifier] NOT NULL,
	[OldProductPriceInclVat] [money] NULL,
	[OldProductPriceExclVat] [money] NULL,
	[SpecialProductPriceInclVat] [money] NULL,
	[SpecialProductPriceExclVat] [money] NULL,
	[IsCampaign] [bit] NULL,
	[IsConnectedProduct] [bit] NOT NULL,
	[HasConnectedProduct] [bit] NOT NULL,
	[IsPerUnit] [bit] NULL,
	[IsForce] [bit] NULL,
	[IsEditable] [bit] NULL,
	[WeightUnit] [nvarchar](100) NULL
  )


  BEGIN TRANSACTION;

    BEGIN TRY
      SET NOCOUNT ON;

      BEGIN

        --:::: set new parked order uuid to set for destination table
        SET @new_parked_order_uuid = NEWID();

        --:::: Save fromParkedOrderUuid(source table uuid) and customer id in variable
        SELECT TOP 1
          @from_parked_order_uuid = a.ParkedOrderUuid,
          @from_customer_id = ISNULL(a.CustomerId, 0)
        FROM --dbo.ParkedOrders po
        (SELECT
          po.IsDeleted,
          po.IsPaymentDone,
          po.ParkedOrderUuid,
          po.TableId,
          po.CustomerId
        FROM dbo.ParkedOrders po
        UNION ALL
        SELECT
          spo.IsDeleted,
          spo.IsPaymentDone,
          spo.ParkedOrderUuid,
          spo.TableId,
          spo.CustomerId
        FROM dbo.ServerParkedOrders spo) a
        WHERE a.TableId = @from_table_id
        AND a.IsDeleted = 0
        AND a.IsPaymentDone = 0

        --:::: save old(existing) fromParkedOrderUuid(source table uuid) records(from both parked orders tables) in temporaray table
        --:::: with IsDeleted=True, IsSync = False, CreatedDateTime = Previous day(so records sync first)
        INSERT @TempExistingParkedOrderTable (TableId,
        LineNumber,
        ProductId,
        ProductName,
        Quantity,
        ProductPriceInclVat,
        ProductPriceExclVat,
        TotalProductPriceInclVat,
        TotalProductPriceExclVat,
        VatRateMultiplier,
        VatRatePercent,
        TotalVatAmount,
        DiscountPercentage,
        ProductDiscount,
        TotalProductDiscount,
        PurchasePrice,
        SubTotal,
        ParkedOrderUuid,
        CustomerId,
        PosId,
        CreatedDateTime,
        CreatedBy,
        UpdatedDateTime,
        UpdatedBy,
        IsActive,
        IsDeleted,
        IsTakeAway,
        IsPriceChanged,
        FailSyncAttemptCount,
        IsSyncSuccess,
        SyncAttemptDate,
        IsLocked,
        IsBonged,
        IsPaymentDone,
        NormalPriceInclVat,
        NormalPriceExclVat,
        TakeAwayPriceInclVat,
        TakeAwayPriceExclVat,
        RowNumberUuid,
		Comment,
		IsCombo,
		ComboParentProductId,
		CartIndexUuid,
		OldProductPriceInclVat,
		OldProductPriceExclVat,
		SpecialProductPriceInclVat,
		SpecialProductPriceExclVat,
		IsCampaign,
		IsConnectedProduct,
	    HasConnectedProduct,
	    IsPerUnit,
	    IsForce,
	    IsEditable,
	    WeightUnit)
          SELECT
            po.TableId,
            po.LineNumber,
            po.ProductId,
            po.ProductName,
            po.Quantity,
            po.ProductPriceInclVat,
            po.ProductPriceExclVat,
            po.TotalProductPriceInclVat,
            po.TotalProductPriceExclVat,
            po.VatRateMultiplier,
            po.VatRatePercent,
            po.TotalVatAmount,
            po.DiscountPercentage,
            po.ProductDiscount,
            po.TotalProductDiscount,
            po.PurchasePrice,
            po.SubTotal,
            po.ParkedOrderUuid,
            po.CustomerId,
            po.PosId,
            @previous_datetime,
            po.CreatedBy,
            @current_datetime,--po.UpdatedDateTime,
            po.UpdatedBy,
            po.IsActive,
            1,
            po.IsTakeAway,
            po.IsPriceChanged,
            0,
            0,
            po.SyncAttemptDate,
            po.IsLocked,
            po.IsBonged,
            po.IsPaymentDone,
            po.NormalPriceInclVat,
            po.NormalPriceExclVat,
            po.TakeAwayPriceInclVat,
            po.TakeAwayPriceExclVat,
            po.RowNumberUuid,
			po.Comment,
			po.IsCombo,
			po.ComboParentProductId,
			po.CartIndexUuid,
			po.OldProductPriceInclVat,
			po.OldProductPriceExclVat,
			po.SpecialProductPriceInclVat,
			po.SpecialProductPriceExclVat,
			po.IsCampaign,
			po.IsConnectedProduct,
			po.HasConnectedProduct,
			po.IsPerUnit,
			po.IsForce,
			po.IsEditable,
			po.WeightUnit
          FROM dbo.ParkedOrders po
          WHERE po.ParkedOrderUuid = @from_parked_order_uuid
          AND po.IsDeleted = 0
          AND po.IsPaymentDone = 0


        INSERT @TempExistingParkedOrderTable (TableId,
        LineNumber,
        ProductId,
        ProductName,
        Quantity,
        ProductPriceInclVat,
        ProductPriceExclVat,
        TotalProductPriceInclVat,
        TotalProductPriceExclVat,
        VatRateMultiplier,
        VatRatePercent,
        TotalVatAmount,
        DiscountPercentage,
        ProductDiscount,
        TotalProductDiscount,
        PurchasePrice,
        SubTotal,
        ParkedOrderUuid,
        CustomerId,
        PosId,
        CreatedDateTime,
        CreatedBy,
        UpdatedDateTime,
        UpdatedBy,
        IsActive,
        IsDeleted,
        IsTakeAway,
        IsPriceChanged,
        FailSyncAttemptCount,
        IsSyncSuccess,
        SyncAttemptDate,
        IsLocked,
        IsBonged,
        IsPaymentDone,
        NormalPriceInclVat,
        NormalPriceExclVat,
        TakeAwayPriceInclVat,
        TakeAwayPriceExclVat,
        RowNumberUuid,
		Comment,
		IsCombo,
		ComboParentProductId,
		CartIndexUuid,
		OldProductPriceInclVat,
		OldProductPriceExclVat,
		SpecialProductPriceInclVat,
		SpecialProductPriceExclVat,
		IsCampaign,
		IsConnectedProduct,
		HasConnectedProduct,
		IsPerUnit,
		IsForce,
		IsEditable,
		WeightUnit)
          SELECT
            po.TableId,
            po.LineNumber,
            po.ProductId,
            po.ProductName,
            po.Quantity,
            po.ProductPriceInclVat,
            po.ProductPriceExclVat,
            po.TotalProductPriceInclVat,
            po.TotalProductPriceExclVat,
            po.VatRateMultiplier,
            po.VatRatePercent,
            po.TotalVatAmount,
            po.DiscountPercentage,
            po.ProductDiscount,
            po.TotalProductDiscount,
            po.PurchasePrice,
            po.SubTotal,
            po.ParkedOrderUuid,
            po.CustomerId,
            po.PosId,
            @previous_datetime,
            po.CreatedBy,
            @current_datetime,--po.UpdatedDateTime,
            po.UpdatedBy,
            po.IsActive,
            1,
            po.IsTakeAway,
            po.IsPriceChanged,
            0,
            0,
            po.SyncAttemptDate,
            po.IsLocked,
            po.IsBonged,
            po.IsPaymentDone,
            po.NormalPriceInclVat,
            po.NormalPriceExclVat,
            po.TakeAwayPriceInclVat,
            po.TakeAwayPriceExclVat,
            po.RowNumberUuid,
			po.Comment,
			po.IsCombo,
			po.ComboParentProductId,
			po.CartIndexUuid,
			po.OldProductPriceInclVat,
			po.OldProductPriceExclVat,
			po.SpecialProductPriceInclVat,
			po.SpecialProductPriceExclVat,
			po.IsCampaign,
			po.IsConnectedProduct,
			po.HasConnectedProduct,
			po.IsPerUnit,
			po.IsForce,
			po.IsEditable,
			po.WeightUnit
          FROM dbo.ServerParkedOrders po
          WHERE po.ParkedOrderUuid = @from_parked_order_uuid
          AND po.IsDeleted = 0
          AND po.IsPaymentDone = 0


        --select @tempCount=count( *) from @TempExistingParkedOrderTable;
        --PRINT 'Count temp 1 ::' + cast(@tempCount AS varchar(20));

        --:::: check if destination table is empty or parked, if already parked then save toParkedOrderUuid and Customer Id
        IF EXISTS (SELECT
            1
          FROM --dbo.ParkedOrders po
          (SELECT
            po.IsDeleted,
            po.IsPaymentDone,
            po.ParkedOrderUuid,
            po.TableId
          FROM dbo.ParkedOrders po
          UNION ALL
          SELECT
            spo.IsDeleted,
            spo.IsPaymentDone,
            spo.ParkedOrderUuid,
            spo.TableId
          FROM dbo.ServerParkedOrders spo) a
          WHERE a.TableId = @to_table_id
          AND a.IsDeleted = 0
          AND a.IsPaymentDone = 0)
        BEGIN
          SELECT TOP 1
            @i = ISNULL(MAX(a.LineNumber), 0) + 1,
            @to_parked_order_uuid = a.ParkedOrderUuid,
            @to_customer_id = ISNULL(a.CustomerId, 0)
          FROM --dbo.ParkedOrders po
          (SELECT
            po.IsDeleted,
            po.LineNumber,
            po.CustomerId,
            po.IsPaymentDone,
            po.ParkedOrderUuid,
            po.TableId
          FROM dbo.ParkedOrders po
          UNION ALL
          SELECT
            spo.IsDeleted,
            spo.LineNumber,
            spo.CustomerId,
            spo.IsPaymentDone,
            spo.ParkedOrderUuid,
            spo.TableId
          FROM dbo.ServerParkedOrders spo) a
          WHERE a.TableId = @to_table_id
          AND a.IsDeleted = 0
          AND a.IsPaymentDone = 0
          GROUP BY a.ParkedOrderUuid,
                   a.CustomerId;



          -- Save toParkedOrderUuid in variable
          --SELECT
          --  @from_parked_order_uuid = po.ParkedOrderUuid
          --FROM dbo.ParkedOrders po
          --WHERE po.TableId = @from_table_id
          --AND po.IsDeleted = 0
          --AND po.IsPaymentDone = 0
          --PRINT 'destination table parked'

          --:::: save old(existing) toParkedOrderUuid(destination table uuid) records(from both parked orders tables) in temporaray table
          --:::: with IsDeleted=True, IsSync = False, CreatedDateTime = Previous day(so records sync first)
          INSERT @TempExistingParkedOrderTable (TableId,
          LineNumber,
          ProductId,
          ProductName,
          Quantity,
          ProductPriceInclVat,
          ProductPriceExclVat,
          TotalProductPriceInclVat,
          TotalProductPriceExclVat,
          VatRateMultiplier,
          VatRatePercent,
          TotalVatAmount,
          DiscountPercentage,
          ProductDiscount,
          TotalProductDiscount,
          PurchasePrice,
          SubTotal,
          ParkedOrderUuid,
          CustomerId,
          PosId,
          CreatedDateTime,
          CreatedBy,
          UpdatedDateTime,
          UpdatedBy,
          IsActive,
          IsDeleted,
          IsTakeAway,
          IsPriceChanged,
          FailSyncAttemptCount,
          IsSyncSuccess,
          SyncAttemptDate,
          IsLocked,
          IsBonged,
          IsPaymentDone,
          NormalPriceInclVat,
          NormalPriceExclVat,
          TakeAwayPriceInclVat,
          TakeAwayPriceExclVat,
          RowNumberUuid,
		  Comment,
		  IsCombo,
		  ComboParentProductId,
		  CartIndexUuid,
		  OldProductPriceInclVat,
		  OldProductPriceExclVat,
		  SpecialProductPriceInclVat,
		  SpecialProductPriceExclVat,
		  IsCampaign,
		  IsConnectedProduct,
		  HasConnectedProduct,
		  IsPerUnit,
		  IsForce,
		  IsEditable,
		  WeightUnit)
            SELECT
              po.TableId,
              po.LineNumber,
              po.ProductId,
              po.ProductName,
              po.Quantity,
              po.ProductPriceInclVat,
              po.ProductPriceExclVat,
              po.TotalProductPriceInclVat,
              po.TotalProductPriceExclVat,
              po.VatRateMultiplier,
              po.VatRatePercent,
              po.TotalVatAmount,
              po.DiscountPercentage,
              po.ProductDiscount,
              po.TotalProductDiscount,
              po.PurchasePrice,
              po.SubTotal,
              po.ParkedOrderUuid,
              po.CustomerId,
              po.PosId,
              @previous_datetime,
              po.CreatedBy,
              @current_datetime,--po.UpdatedDateTime,
              po.UpdatedBy,
              po.IsActive,
              1,
              po.IsTakeAway,
              po.IsPriceChanged,
              0,
              0,
              po.SyncAttemptDate,
              po.IsLocked,
              po.IsBonged,
              po.IsPaymentDone,
              po.NormalPriceInclVat,
              po.NormalPriceExclVat,
              po.TakeAwayPriceInclVat,
              po.TakeAwayPriceExclVat,
              po.RowNumberUuid,
			  po.Comment,
			  po.IsCombo,
			  po.ComboParentProductId,
			  po.CartIndexUuid,
			  po.OldProductPriceInclVat,
			  po.OldProductPriceExclVat,
			  po.SpecialProductPriceInclVat,
			  po.SpecialProductPriceExclVat,
			  po.IsCampaign,
			  po.IsConnectedProduct,
			  po.HasConnectedProduct,
			  po.IsPerUnit,
			  po.IsForce,
			  po.IsEditable,
			  po.WeightUnit
            FROM dbo.ParkedOrders po
            WHERE po.ParkedOrderUuid = @to_parked_order_uuid
            AND po.IsDeleted = 0
            AND po.IsPaymentDone = 0


          INSERT @TempExistingParkedOrderTable (TableId,
          LineNumber,
          ProductId,
          ProductName,
          Quantity,
          ProductPriceInclVat,
          ProductPriceExclVat,
          TotalProductPriceInclVat,
          TotalProductPriceExclVat,
          VatRateMultiplier,
          VatRatePercent,
          TotalVatAmount,
          DiscountPercentage,
          ProductDiscount,
          TotalProductDiscount,
          PurchasePrice,
          SubTotal,
          ParkedOrderUuid,
          CustomerId,
          PosId,
          CreatedDateTime,
          CreatedBy,
          UpdatedDateTime,
          UpdatedBy,
          IsActive,
          IsDeleted,
          IsTakeAway,
          IsPriceChanged,
          FailSyncAttemptCount,
          IsSyncSuccess,
          SyncAttemptDate,
          IsLocked,
          IsBonged,
          IsPaymentDone,
          NormalPriceInclVat,
          NormalPriceExclVat,
          TakeAwayPriceInclVat,
          TakeAwayPriceExclVat,
          RowNumberUuid,
		  Comment,
		  IsCombo,
		  ComboParentProductId,
		  CartIndexUuid,
		  OldProductPriceInclVat,
		  OldProductPriceExclVat,
		  SpecialProductPriceInclVat,
		  SpecialProductPriceExclVat,
		  IsCampaign,
		  IsConnectedProduct,
		  HasConnectedProduct,
		  IsPerUnit,
		  IsForce,
		  IsEditable,
		  WeightUnit)
            SELECT
              po.TableId,
              po.LineNumber,
              po.ProductId,
              po.ProductName,
              po.Quantity,
              po.ProductPriceInclVat,
              po.ProductPriceExclVat,
              po.TotalProductPriceInclVat,
              po.TotalProductPriceExclVat,
              po.VatRateMultiplier,
              po.VatRatePercent,
              po.TotalVatAmount,
              po.DiscountPercentage,
              po.ProductDiscount,
              po.TotalProductDiscount,
              po.PurchasePrice,
              po.SubTotal,
              po.ParkedOrderUuid,
              po.CustomerId,
              po.PosId,
              @previous_datetime,
              po.CreatedBy,
              @current_datetime,--po.UpdatedDateTime,
              po.UpdatedBy,
              po.IsActive,
              1,
              po.IsTakeAway,
              po.IsPriceChanged,
              0,
              0,
              po.SyncAttemptDate,
              po.IsLocked,
              po.IsBonged,
              po.IsPaymentDone,
              po.NormalPriceInclVat,
              po.NormalPriceExclVat,
              po.TakeAwayPriceInclVat,
              po.TakeAwayPriceExclVat,
              po.RowNumberUuid,
			  po.Comment,
			  po.IsCombo,
			  po.ComboParentProductId,
			  po.CartIndexUuid,
			  po.OldProductPriceInclVat,
			  po.OldProductPriceExclVat,
			  po.SpecialProductPriceInclVat,
			  po.SpecialProductPriceExclVat,
			  po.IsCampaign,
			  po.IsConnectedProduct,
			  po.HasConnectedProduct,
			  po.IsPerUnit,
			  po.IsForce,
			  po.IsEditable,
			  po.WeightUnit
            FROM dbo.ServerParkedOrders po
            WHERE po.ParkedOrderUuid = @to_parked_order_uuid
            AND po.IsDeleted = 0
            AND po.IsPaymentDone = 0

        END
        ELSE
        BEGIN
          SET @to_customer_id = -1;
        END

        IF (@to_customer_id = 0
          AND @from_customer_id = 0)
        BEGIN
          SET @customer_id = NULL;
        END
        ELSE
        IF (@to_customer_id = 0
          AND @from_customer_id > 0)
        BEGIN
          --PRINT 'customer id condition'
          SET @customer_id = @from_customer_id;

          --:::: update records of destination tables with updated customer id and new guid
          UPDATE dbo.ParkedOrders
          SET dbo.ParkedOrders.CustomerId = @customer_id, -- int
              dbo.ParkedOrders.PosId = @pos_id, -- int
              dbo.ParkedOrders.ParkedOrderUuid = @new_parked_order_uuid, -- uniqueidentifier
              dbo.ParkedOrders.UpdatedDateTime = @current_datetime, -- datetime
              dbo.ParkedOrders.UpdatedBy = @user_id -- int
          WHERE dbo.ParkedOrders.TableId = @to_table_id

          UPDATE dbo.ServerParkedOrders
          SET dbo.ServerParkedOrders.CustomerId = @customer_id, -- int
              dbo.ServerParkedOrders.ParkedOrderUuid = @new_parked_order_uuid, -- uniqueidentifier
              dbo.ServerParkedOrders.PosId = @pos_id, -- int
              dbo.ServerParkedOrders.UpdatedDateTime = @current_datetime, -- datetime
              dbo.ServerParkedOrders.UpdatedBy = @user_id -- int
          WHERE dbo.ServerParkedOrders.TableId = @to_table_id

        END
        ELSE
        IF (@to_customer_id > 0
          AND @from_customer_id > 0)
        BEGIN
          SET @customer_id = @to_customer_id;
        END
        ELSE
        IF (@to_customer_id > 0
          AND @from_customer_id = 0)
        BEGIN
          SET @customer_id = @to_customer_id;
        END

        --:::: if destination table is empty
        IF (@to_customer_id = -1)
        BEGIN
          --PRINT 'if destination table is empty'
          --:::: update records of source tables with new guid and new table id(destination tableid)
          UPDATE dbo.ParkedOrders
          SET dbo.ParkedOrders.TableId = @to_table_id, -- int
              dbo.ParkedOrders.ParkedOrderUuid = @new_parked_order_uuid, -- uniqueidentifier
              dbo.ParkedOrders.UpdatedDateTime = @current_datetime, -- datetime
              dbo.ParkedOrders.UpdatedBy = @user_id, -- int
              dbo.ParkedOrders.FailSyncAttemptCount = 0, -- tinyint
              dbo.ParkedOrders.IsSyncSuccess = 1 -- bit
          WHERE dbo.ParkedOrders.TableId = @from_table_id


          UPDATE dbo.ServerParkedOrders
          SET dbo.ServerParkedOrders.TableId = @to_table_id, -- int
              dbo.ServerParkedOrders.ParkedOrderUuid = @new_parked_order_uuid, -- uniqueidentifier
              dbo.ServerParkedOrders.UpdatedDateTime = @current_datetime, -- datetime
              dbo.ServerParkedOrders.UpdatedBy = @user_id, -- int
              dbo.ServerParkedOrders.FailSyncAttemptCount = 0, -- tinyint
              dbo.ServerParkedOrders.IsSyncSuccess = 1 -- bit
          WHERE dbo.ServerParkedOrders.TableId = @from_table_id

          --:::: insert records from server parked orders to main parked orders for SYNC
          INSERT dbo.ParkedOrders (
          --ParkedOrderId - this column value is auto-generated
          TableId,
          LineNumber,
          ProductId,
          ProductName,
          Quantity,
          ProductPriceInclVat,
          ProductPriceExclVat,
          TotalProductPriceInclVat,
          TotalProductPriceExclVat,
          VatRateMultiplier,
          VatRatePercent,
          TotalVatAmount,
          DiscountPercentage,
          ProductDiscount,
          TotalProductDiscount,
          PurchasePrice,
          SubTotal,
          ParkedOrderUuid,
          CustomerId,
          PosId,
          CreatedDateTime,
          CreatedBy,
          UpdatedDateTime,
          UpdatedBy,
          IsActive,
          IsDeleted,
          IsTakeAway,
          IsPriceChanged,
          FailSyncAttemptCount,
          IsSyncSuccess,
          SyncAttemptDate,
          IsLocked,
          IsBonged,
          IsPaymentDone,
          NormalPriceInclVat,
          NormalPriceExclVat,
          TakeAwayPriceInclVat,
          TakeAwayPriceExclVat,
          RowNumberUuid,
		  Comment,
		  IsCombo,
		  ComboParentProductId,
		  CartIndexUuid,
		  OldProductPriceInclVat,
		  OldProductPriceExclVat,
		  SpecialProductPriceInclVat,
		  SpecialProductPriceExclVat,
		  IsCampaign,
		  IsConnectedProduct,
		  HasConnectedProduct,
		  IsPerUnit,
		  IsForce,
		  IsEditable,
		  WeightUnit)
            SELECT
              TableId,
              LineNumber,
              ProductId,
              ProductName,
              Quantity,
              ProductPriceInclVat,
              ProductPriceExclVat,
              TotalProductPriceInclVat,
              TotalProductPriceExclVat,
              VatRateMultiplier,
              VatRatePercent,
              TotalVatAmount,
              DiscountPercentage,
              ProductDiscount,
              TotalProductDiscount,
              PurchasePrice,
              SubTotal,
              ParkedOrderUuid,
              CustomerId,
              PosId,
              CreatedDateTime,
              CreatedBy,
              UpdatedDateTime,
              UpdatedBy,
              IsActive,
              IsDeleted,
              IsTakeAway,
              IsPriceChanged,
              FailSyncAttemptCount,
              IsSyncSuccess,
              SyncAttemptDate,
              IsLocked,
              IsBonged,
              IsPaymentDone,
              NormalPriceInclVat,
              NormalPriceExclVat,
              TakeAwayPriceInclVat,
              TakeAwayPriceExclVat,
              RowNumberUuid,
			  Comment,
			  IsCombo,
			  ComboParentProductId,
			  CartIndexUuid,
			  OldProductPriceInclVat,
			  OldProductPriceExclVat,
			  SpecialProductPriceInclVat,
		      SpecialProductPriceExclVat,
		      IsCampaign,
			  IsConnectedProduct,
			  HasConnectedProduct,
			  IsPerUnit,
			  IsForce,
			  IsEditable,
			  WeightUnit
            FROM dbo.ServerParkedOrders spo
            WHERE spo.TableId = @to_table_id

          UPDATE dbo.ParkedOrders
          SET dbo.ParkedOrders.IsSyncSuccess = 0 -- bit
          WHERE dbo.ParkedOrders.TableId = @to_table_id

        END
        ELSE
        --:::: if destination table is NOT empty and already parked
        BEGIN
          --PRINT 'if destination table is NOT empty and already parked'
          UPDATE dbo.ParkedOrders
          SET dbo.ParkedOrders.TableId = @to_table_id, -- int
              dbo.ParkedOrders.LineNumber = @i,
              @i = @i + 1, -- tinyint
              dbo.ParkedOrders.ParkedOrderUuid = @new_parked_order_uuid, -- uniqueidentifier
              -- dbo.ParkedOrders.ParkedOrderUuid = @to_parked_order_uuid, -- uniqueidentifier
              dbo.ParkedOrders.CustomerId = @customer_id, -- int
              dbo.ParkedOrders.PosId = @pos_id, -- int
              dbo.ParkedOrders.UpdatedDateTime = @current_datetime, -- datetime
              dbo.ParkedOrders.UpdatedBy = @user_id, -- int
              dbo.ParkedOrders.FailSyncAttemptCount = 0, -- tinyint
              dbo.ParkedOrders.IsSyncSuccess = 1 -- bit
          WHERE dbo.ParkedOrders.TableId = @from_table_id
          OR dbo.ParkedOrders.TableId = @to_table_id


          UPDATE dbo.ServerParkedOrders
          SET dbo.ServerParkedOrders.TableId = @to_table_id, -- int
              dbo.ServerParkedOrders.LineNumber = @i,
              @i = @i + 1, -- tinyint
              dbo.ServerParkedOrders.ParkedOrderUuid = @new_parked_order_uuid, -- uniqueidentifier
              --dbo.ServerParkedOrders.ParkedOrderUuid = @to_parked_order_uuid, -- uniqueidentifier
              dbo.ServerParkedOrders.CustomerId = @customer_id, -- int
              dbo.ServerParkedOrders.PosId = @pos_id, -- int
              dbo.ServerParkedOrders.UpdatedDateTime = @current_datetime, -- datetime
              dbo.ServerParkedOrders.UpdatedBy = @user_id, -- int
              dbo.ServerParkedOrders.FailSyncAttemptCount = 0, -- tinyint
              dbo.ServerParkedOrders.IsSyncSuccess = 1 -- bit
          WHERE dbo.ServerParkedOrders.TableId = @from_table_id
          OR dbo.ServerParkedOrders.TableId = @to_table_id

          --:::: insert records from server parked orders to main parked orders for SYNC
          INSERT dbo.ParkedOrders (
          --ParkedOrderId - this column value is auto-generated
          TableId,
          LineNumber,
          ProductId,
          ProductName,
          Quantity,
          ProductPriceInclVat,
          ProductPriceExclVat,
          TotalProductPriceInclVat,
          TotalProductPriceExclVat,
          VatRateMultiplier,
          VatRatePercent,
          TotalVatAmount,
          DiscountPercentage,
          ProductDiscount,
          TotalProductDiscount,
          PurchasePrice,
          SubTotal,
          ParkedOrderUuid,
          CustomerId,
          PosId,
          CreatedDateTime,
          CreatedBy,
          UpdatedDateTime,
          UpdatedBy,
          IsActive,
          IsDeleted,
          IsTakeAway,
          IsPriceChanged,
          FailSyncAttemptCount,
          IsSyncSuccess,
          SyncAttemptDate,
          IsLocked,
          IsBonged,
          IsPaymentDone,
          NormalPriceInclVat,
          NormalPriceExclVat,
          TakeAwayPriceInclVat,
          TakeAwayPriceExclVat,
          RowNumberUuid,
		  Comment,
		  IsCombo,
		  ComboParentProductId,
		  CartIndexUuid,
		  OldProductPriceInclVat,
		  OldProductPriceExclVat,
		  SpecialProductPriceInclVat,
		  SpecialProductPriceExclVat,
		  IsCampaign,
		  IsConnectedProduct,
	      HasConnectedProduct,
		  IsPerUnit,
		  IsForce,
		  IsEditable,
		  WeightUnit)
            SELECT
              TableId,
              LineNumber,
              ProductId,
              ProductName,
              Quantity,
              ProductPriceInclVat,
              ProductPriceExclVat,
              TotalProductPriceInclVat,
              TotalProductPriceExclVat,
              VatRateMultiplier,
              VatRatePercent,
              TotalVatAmount,
              DiscountPercentage,
              ProductDiscount,
              TotalProductDiscount,
              PurchasePrice,
              SubTotal,
              ParkedOrderUuid,
              CustomerId,
              PosId,
              CreatedDateTime,
              CreatedBy,
              @current_datetime,--po.UpdatedDateTime,
              UpdatedBy,
              IsActive,
              IsDeleted,
              IsTakeAway,
              IsPriceChanged,
              FailSyncAttemptCount,
              IsSyncSuccess,
              SyncAttemptDate,
              IsLocked,
              IsBonged,
              IsPaymentDone,
              NormalPriceInclVat,
              NormalPriceExclVat,
              TakeAwayPriceInclVat,
              TakeAwayPriceExclVat,
              RowNumberUuid,
			  Comment,
			  IsCombo,
			  ComboParentProductId,
			  CartIndexUuid,
			  OldProductPriceInclVat,
		      OldProductPriceExclVat,
		      SpecialProductPriceInclVat,
		      SpecialProductPriceExclVat,
		      IsCampaign,
			  IsConnectedProduct,
			  HasConnectedProduct,
			  IsPerUnit,
			  IsForce,
			  IsEditable,
			  WeightUnit
            FROM dbo.ServerParkedOrders spo
            WHERE spo.TableId = @to_table_id


          UPDATE dbo.ParkedOrders
          SET dbo.ParkedOrders.IsSyncSuccess = 0 -- bit
          WHERE dbo.ParkedOrders.TableId = @to_table_id

        END

        --:::: insert temp table records in parkedOrders table
        INSERT dbo.ParkedOrders (TableId,
        LineNumber,
        ProductId,
        ProductName,
        Quantity,
        ProductPriceInclVat,
        ProductPriceExclVat,
        TotalProductPriceInclVat,
        TotalProductPriceExclVat,
        VatRateMultiplier,
        VatRatePercent,
        TotalVatAmount,
        DiscountPercentage,
        ProductDiscount,
        TotalProductDiscount,
        PurchasePrice,
        SubTotal,
        ParkedOrderUuid,
        CustomerId,
        PosId,
        CreatedDateTime,
        CreatedBy,
        UpdatedDateTime,
        UpdatedBy,
        IsActive,
        IsDeleted,
        IsTakeAway,
        IsPriceChanged,
        FailSyncAttemptCount,
        IsSyncSuccess,
        SyncAttemptDate,
        IsLocked,
        IsBonged,
        IsPaymentDone,
        NormalPriceInclVat,
        NormalPriceExclVat,
        TakeAwayPriceInclVat,
        TakeAwayPriceExclVat,
        RowNumberUuid,
		Comment,
		IsCombo,
		ComboParentProductId,
		CartIndexUuid,
		OldProductPriceInclVat,
		OldProductPriceExclVat,
		SpecialProductPriceInclVat,
		SpecialProductPriceExclVat,
		IsCampaign,
		IsConnectedProduct,
		HasConnectedProduct,
		IsPerUnit,
		IsForce,
		IsEditable,
		WeightUnit)
          SELECT
            tepot.*
          FROM @TempExistingParkedOrderTable tepot

        --:::: Delete temp table records
        DELETE FROM @TempExistingParkedOrderTable
      --select @tempCount=count( *) from @TempExistingParkedOrderTable;
      --PRINT 'Count temp 2 ::' + cast(@tempCount AS varchar(20));

      COMMIT TRANSACTION



      --  DELETE FROM @TempExistingParkedOrderTable
      SET @IsSuccess = 1
    END

  END TRY

  BEGIN CATCH
    ROLLBACK TRANSACTION;

    SET @IsSuccess = 0
  END CATCH;

  SELECT
    @IsSuccess
END




GO
/****** Object:  StoredProcedure [dbo].[sp_TodayOrderDetails]    Script Date: 14-09-2017 10:37:00 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Ver: 1.0.12
-- =============================================
-- sp_TodayOrderDetails
CREATE PROCEDURE [dbo].[sp_TodayOrderDetails]

AS
BEGIN
  SET NOCOUNT ON;
  SELECT
    CONVERT(varchar(10), t1.OrderDateTime, 104) AS [Date],						-- Date
    ROUND(SUM(t2.TotalProductPriceExclVat), 2) AS [TurnoverExclVAT],	-- Turnover
    ROUND(SUM(t2.TotalProductPriceInclVat), 2) AS [TurnoverInclVAT],		-- Turnover with VAT
    --count(t1.OrderId) as TotalOrders,														-- Amount of orders
    (SELECT
      COUNT(orderid)
    FROM orders
    WHERE CONVERT(date, OrderDateTime) = CONVERT(date, GETDATE()))
    AS TotalOrders,
    ROUND(SUM(t3.PurchasePrice * t2.Quantity), 2) AS CostPrice,								-- Cost price
    ROUND(SUM(t2.TotalProductPriceInclVat -									-- Profit
    ((t2.Quantity * t3.PurchasePrice))), 2) AS Profit,
    SUM(t2.TotalProductPriceInclVat - (t2.Quantity * t3.PurchasePrice)) AS BF,			-- BF kr
    SUM(((t2.TotalProductPriceInclVat - (t2.Quantity * t3.PurchasePrice)) /				-- BF %
    ISNULL(NULLIF((t2.TotalProductPriceInclVat), 0), 1)) * 100) AS BF2
  FROM Orders t1
  LEFT JOIN OrderDetails t2
    ON (t1.OrderId = t2.OrderID)
  LEFT JOIN Products t3
    ON (t2.ProductID = t3.ProductId)
  WHERE CONVERT(date, OrderDateTime) = CONVERT(date, GETDATE()) AND t3.IsCombo = 0
  GROUP BY CONVERT(varchar(10), t1.OrderDateTime, 104)
END

GO
USE [master]
GO
ALTER DATABASE [ProTouch] SET  READ_WRITE 
GO


-- For Live Server
USE [ProTouch]
GO
SET NOCOUNT ON;
INSERT [dbo].[ApiDetails] ([Id], [ApiUsername], [ApiPassword], [ApiUrl], [ApiHeaderName], [ApiHeaderValuePrefix], [AutoUpdateUrl], [LastSuccessfulStartupDate]) VALUES (1, N'', N'', N'biMgZOIanmUcDziMbVZlt7BzxAKIX4JJMwsENYoEjWI=', N'A4be9QLNxdN5k2/JVdjMuA==', N'IdXHGxvYnYbQsP3j2QT8Qg==', N'fnEGqJi5GQPKk7txi2eQI/faBKSOi9T+lr+6rzw32P2P56Dq4ImgM8tMTN4C9RPvOr1p9RYjvBrpB6ArfriKNw==', NULL)
GO
SET IDENTITY_INSERT [dbo].[SyncDetails] ON 

GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (1, N'CoreSetup', 1, N'ClientDetails', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (2, N'CoreSetup', 2, N'DepartmentDetails', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (3, N'CoreSetup', 3, N'PosDetails', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (4, N'FULLSYNC', 0, N'FullSync', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (5, N'General', 1, N'PaymentTypes', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (6, N'General', 2, N'SupportContactDetails', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (7, N'ReceiveCustomers', 1, N'ReceiveCustomers', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (8, N'ZipCode', 1, N'ZipCode', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (9, N'Products', 1, N'Category', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (10, N'Products', 2, N'VariantGroups', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (11, N'Products', 3, N'VariantGroupValues', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (12, N'Products', 4, N'VatRate', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (13, N'Products', 5, N'Suppliers', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (14, N'Products', 6, N'SupplierContactPersons', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (15, N'Products', 7, N'Brands', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (16, N'Products', 8, N'BrandSuppliers', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (17, N'Products', 9, N'ProductUnit', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (18, N'Products', 10, N'Products', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (19, N'Products', 11, N'ProductVariants', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (20, N'Products', 12, N'ProductStock', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (21, N'Products', 13, N'ProductSuppliers', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (22, N'Tiles', 2, N'Folders', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (23, N'Tiles', 3, N'Tiles', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (24, N'Tiles', 4, N'TileProducts', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (25, N'Users', 1, N'Permissions', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (26, N'Users', 2, N'UserGroups', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (27, N'Users', 3, N'UserGroupPermissions', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (28, N'Users', 4, N'Users', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (29, N'SendCustomers', 1, N'SendCustomers', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (30, N'Orders', 1, N'Orders', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (31, N'CashSettlement', 1, N'CashSettlement', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (32, N'PosSettings', 1, N'PosSettings', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (33, N'LoginHistory', 1, N'LoginHistory', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (34, N'General', 3, N'PosModules', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (35, N'Tiles', 1, N'TileGroup', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (36, N'SOH', 1, N'Rooms', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (37, N'SOH', 2, N'Tables', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (38, N'SOH', 3, N'ParkedOrder', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (39, N'CampaignDiscount', 1, N'CampaignDiscount', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (40, N'SASettings', 1, N'SASettings', NULL)
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (41, N'AppLog', 1, N'AppLog', getdate())
GO
SET NOCOUNT ON;
INSERT [dbo].[SyncDetails] ([Id], [GroupName], [SyncOrder], [TableName], [LastSyncDate]) VALUES (42, N'Products', 14, N'AllProductStock', NULL)
GO
SET IDENTITY_INSERT [dbo].[SyncDetails] OFF
GO

-- LogoOption Table with values
GO
SET NOCOUNT ON;
INSERT [dbo].[LogoOption] ([LogoOptionId], [LogoOption]) VALUES (N'1', N'Logo uploaded in Printer')
GO
SET NOCOUNT ON;
INSERT [dbo].[LogoOption] ([LogoOptionId], [LogoOption]) VALUES (N'2', N'Logo uploaded through application')
GO
SET NOCOUNT ON;
INSERT [dbo].[LogoOption] ([LogoOptionId], [LogoOption]) VALUES (N'3', N'No Logo')

-- JournalBasicTypes Table with values
SET IDENTITY_INSERT [dbo].[JournalBasicTypes] ON 

GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (1, N'01', N'Cost codes', N'Kostnadssted')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (2, N'02', N'Product codes', N'Produkt koder (PLU)')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (3, N'03', N'Project codes', N'Prosjekt koder')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (4, N'04', N'Article Group codes', N'Varegruppekoder')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (5, N'05', N'Ticketline codes', N'Varelinjekoder')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (6, N'06', N'Logging codes', N'Logging i systemet, backup etc (ikke bruker/hendelses-basert)')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (7, N'07', N'Savings codes', N'Rabatter per enhet (3 or 2 etc)')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (8, N'08', N'Discount codes', N'Rabatt i pris (prosent avslag etc)')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (9, N'09', N'Quantity codes / Quantity ID', N'Definisjon av antall')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (10, N'10', N'Raise codes', N'Tips beløp, eller påslag i pris for definerte kundegrupper')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (11, N'11', N'Transaction codes ', N'Transaksjonstyper')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (12, N'12', N'Payment codes', N'Betalingsmåter')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (13, N'13', N'Event codes', N'Hendelser som ikke er salg')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (14, N'14', N'Service code', N'Systemleverandør service hendelser')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (15, N'15', N'User codes / User ID', N'Brukeridenten på systemet (kan også tilsvare empID)')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalBasicTypes] ([BasicTypeId], [BasicType], [EnglishName], [NorwegianDescription]) VALUES (16, N'16', N'Other', N'Øvrige')
GO
SET IDENTITY_INSERT [dbo].[JournalBasicTypes] OFF

-- JournalEventCodes Table with values
GO
SET IDENTITY_INSERT [dbo].[JournalEventCodes] ON 

GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (1, N'13', N'PosStart', N'13001', N'POS application start', N'Oppstart av POS applikasjon')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (2, N'13', N'PosShutDown', N'13002', N'POS application shut down', N'Avslutning av POS applikasjon')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (3, N'13', N'EmpLogIn', N'13003', N'Employee log in', N'Pålogging bruker/ansatt')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (4, N'13', N'EmpLogOut', N'13004', N'Employee log out', N'Avlogging bruker/ansatt')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (5, N'13', N'OpenDrawer', N'13005', N'Open cash drawer', N'Kasseskuff åpning')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (6, N'13', N'CloseDrawer', N'13006', N'Close cash drawer', N'Kasseskuff lukking')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (7, N'13', N'UpdatePos', N'13007', N'Update of POS application', N'Oppdatering av programvare')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (8, N'13', N'XReport', N'13008', N'X report', N'Kjøring av X-rapport')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (9, N'13', N'ZReport', N'13009', N'Z report', N'Kjøring av Z-rapport')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (10, N'13', N'SuspendTransaction', N'13010', N'Suspend transaction', N'Parkering av kvittering/bong')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (11, N'13', N'ResumeTransaction', N'13011', N'Resume transaction', N'Tilbakehenting av parkert kvittering/bong')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (12, N'13', N'SalesReceipt', N'13012', N'Sales receipt', N'Salgskvittering')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (13, N'13', N'ReturnReceipt', N'13013', N'Return receipt', N'Returkvittering')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (14, N'13', N'CopyReceipt', N'13014', N'Copy receipt', N'Kopi av kvittering')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (15, N'13', N'ProFormaReceipt', N'13015', N'Pro forma receipt', N'Proforma kvittering')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (16, N'13', N'DeliveryReceipt', N'13016', N'Delivery receipt', N'Utleveringskvittering ved kredittsalg')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (17, N'13', N'TrainingReceipt', N'13017', N'Training receipt ', N'Treningsmodus - alle typer kvitteringer')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (18, N'13', N'OtherReceipts', N'13018', N'Other reports or receipts', N'Andre rapporter eller kvitteringer')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (19, N'13', N'CashWithDraw', N'13019', N'Cash withdrawal', N'Uttak av kontanter fra kasse')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (22, N'13', N'ExportJournal', N'13020', N'Export of journal to external storage (cash register)', N'Overføring av journal til annet lagringsmedie (ROM kasser)')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (23, N'13', N'PriceChange', N'13021', N'Price change', N'Prisendringer')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (24, N'13', N'PriceCheck', N'13022', N'Price look-up', N'Prisundersøkelse')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (25, N'13', N'TrainingModeOn', N'13023', N'Training mode on', N'Trenings- modus/funksjon på')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (26, N'13', N'TrainingModeOff', N'13024', N'Training mode off', N'Trenings- modus/funksjon av')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (27, N'13', N'MemoryFull', N'13025', N'Memory full (cash register)', N'Fullt minne (ROM kasser)')
GO
SET NOCOUNT ON;
INSERT [dbo].[JournalEventCodes] ([EventCodeId], [BasicType], [BasicId], [PredefinedBasicId], [EnglishName], [NorwegianDescription]) VALUES (28, N'13', N'Other', N'13999', N'Other', N'Øvrige hendelser')
GO
SET NOCOUNT ON;
SET IDENTITY_INSERT [dbo].[JournalEventCodes] OFF
Go

-- Insert records in CashRegisterCounters - Start
IF  EXISTS (SELECT * FROM sys.objects 
WHERE object_id = OBJECT_ID(N'[dbo].[CashRegisterCounters]') AND type in (N'U'))
BEGIN

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfSalesReceiptsValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfSalesReceiptsValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfSalesReceiptCopiesValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfSalesReceiptCopiesValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfTemporaryReceiptsValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfTemporaryReceiptsValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfInvoiceReceiptsValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfInvoiceReceiptsValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfCancelledOrdersValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfCancelledOrdersValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfTotalCreditSalesValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfTotalCreditSalesValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfTotalNoneCreditSalesValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfTotalNoneCreditSalesValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfCashDrawerOpen')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfCashDrawerOpen', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfTakeAwayOn')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfTakeAwayOn', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfTakeAwayOff')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfTakeAwayOff', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfChangedPriceValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfChangedPriceValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfDiscountsValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfDiscountsValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfChangedQuantityValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfChangedQuantityValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfDeletedProductsValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfDeletedProductsValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfXReport')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfXReport', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfZReport')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfZReport', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfGiftCardsValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfGiftCardsValue', 0)
END

IF NOT EXISTS (SELECT CounterCode FROM CashRegisterCounters WHERE CounterCode = N'NumberOfCreditNotesValue')
BEGIN
Set NOCOUNT ON; INSERT [dbo].[CashRegisterCounters] ([CounterCode], [Counter]) VALUES (N'NumberOfCreditNotesValue', 0)
END

END
-- Insert records in CashRegisterCounters - Finish